% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regenerate.R
\name{regenerate}
\alias{regenerate}
\title{Regenerate n-grams}
\usage{
regenerate(x, element_groups)
}
\arguments{
\item{x}{\code{character} string representing single n-gram.}

\item{element_groups}{encoding of elements: list of groups to which elements 
of sequence should be aggregated. Must have unique names.}
}
\value{
A \code{character} string representing a POSIX regular expression.
}
\description{
'Regenerates' amino acid or nucleic sequence written in a simplified 
alphabet by converting groups to regular expression.
}
\note{
Gaps (\code{_}) will be converted to any possible character from the alphabet
(nucleotides or amino acids).
}
\examples{
regenerate("ssw", list(w = c(1, 4), s = c(2, 3)))
}
\seealso{
\code{\link{degenerate}} to easily convert information stored in biological sequences from 
letters to numbers.
\code{\link{calc_ed}} to calculate distance between simplified alphabets.
}
\keyword{manip}
