% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iris.R
\name{get_iris_raw_task}
\alias{get_iris_raw_task}
\title{Check the \code{task} type of an IRIS RAW file}
\usage{
get_iris_raw_task(
  file,
  header_size = 50,
  task = c("WIND", "SURVEILLANCE", "VOL_A", "VOL_B")
)
}
\arguments{
\item{file}{Character. Path to a polar volume file in IRIS RAW format.}

\item{header_size}{Integer. Number of header bytes to search.}

\item{task}{Character (vector). Task names to search for in the file header.}
}
\value{
Specified \code{task} names found in the header or \code{NA} if none of the
task names were found.
}
\description{
Checks what type of \code{task}(s), i.e. polar volume types, are contained in an
IRIS RAW file.
}
