% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze_position.R
\name{analyze_position}
\alias{analyze_position}
\title{Analyze position}
\usage{
analyze_position(engine, san = NULL, lan = NULL, ...)
}
\arguments{
\item{engine}{engine path or engine object from uci_engine()}

\item{san}{movetext in short algebraic notation, default NULL}

\item{lan}{movetext in long algebraic notation, default NULL}

\item{...}{further arguments passed directly to uci_go()}
}
\value{
list containg bestomove, score and bestlines
}
\description{
Analyze position using UCI engine and R API
}
\examples{
\donttest{
# Linux (make sure you have executable permission):
engine_path <- "./stockfish_10_x64"
# Windows
# engine_path <- "./stockfish_10_x64.exe"
require(magrittr)
ap <- analyze_position(engine_path,san = "1. e4",depth = 20)
ap$bestmove_lan
# "e7e5"
ap$score
# -7
ap$bestmove_san
# "e5"
ap$curpos_lan
# "e2e4"
ap$curpos_san
# "1. e4"
ap$bestline_san
# "e5 2. Nf3 Nc6 3. d4 exd4 4. Bc4 Nf6 5. O-O Be7
# 6. Re1 d6 7. Nxd4 Ne5 8. Bb3 O-O 9. Nc3 c5
# 10. Nf5 Bxf5 11. exf5 c4 12. Ba4 a6 13. Qe2"
ap$bestline_lan
# "e7e5 g1f3 b8c6 d2d4 e5d4 f1c4 g8f6 e1g1 f8e7
# f1e1 d7d6 f3d4 c6e5 c4b3 e8g8 b1c3 c7c5 d4f5
# c8f5 e4f5 c5c4 b3a4 a7a6 d1e2"
}
}
