% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamicWhittle_miscellanea_zigzag.R
\name{dbList_dw_Bern_for_lambda}
\alias{dbList_dw_Bern_for_lambda}
\title{Construct Bernstein polynomial bases of degree up to kmax on omega for frequency parameter lambda}
\usage{
dbList_dw_Bern_for_lambda(
  omega,
  kmax,
  bernstein_l = 0,
  bernstein_r = 1,
  m,
  time_grid
)
}
\arguments{
\item{omega}{numeric vector in \eqn{[0,1]} of evaluation points}

\item{kmax}{positive integer for the largest degree}

\item{bernstein_l, bernstein_r}{left and right truncation related to the dilation}
}
\value{
A list of length kmax, where the k-th list element is a matrix containing the polynomial basis of degree k
}
\description{
Construct Bernstein polynomial bases of degree up to kmax on omega for frequency parameter lambda
}
\examples{
\dontrun{
omega <- time_grid <- seq(0, 1, by = 0.01)
dbList_dw_Bern_for_lambda(omega, 100, 0.1, 0.9)
}
}
\keyword{internal}
