% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaSandwich-beta-adf.R
\name{BetaADF}
\alias{BetaADF}
\title{Estimate Standardized Regression Coefficients
and the Corresponding Sampling Covariance Matrix
Using the Asymptotic Distribution-Free Approach}
\usage{
BetaADF(object, alpha = c(0.05, 0.01, 0.001))
}
\arguments{
\item{object}{Object of class \code{lm}.}

\item{alpha}{Numeric vector.
Significance level \eqn{\alpha}.}
}
\value{
Returns an object
of class \code{betasandwich} which is a list with the following elements:
\describe{
\item{call}{Function call.}
\item{args}{Function arguments.}
\item{lm_process}{Processed \code{lm} object.}
\item{gamma_n}{Asymptotic covariance matrix
of the sample covariance matrix
assuming multivariate normality.}
\item{gamma_hc}{Asymptotic covariance matrix
HC correction.}
\item{gamma}{Asymptotic covariance matrix
of the sample covariance matrix.}
\item{acov}{Asymptotic covariance matrix
of the standardized slopes.}
\item{vcov}{Sampling covariance matrix
of the standardized slopes.}
\item{est}{Vector of standardized slopes.}
}
}
\description{
Estimate Standardized Regression Coefficients
and the Corresponding Sampling Covariance Matrix
Using the Asymptotic Distribution-Free Approach
}
\details{
Note that while the calculation in \code{\link[=BetaADF]{BetaADF()}}
is different from \code{\link[betaDelta:BetaDelta]{betaDelta::BetaDelta()}} with \code{type = "adf"},
the results are numerically equivalent.
\code{\link[=BetaADF]{BetaADF()}} is appropriate when sample sizes are moderate to large
(\code{n > 250}).
\code{\link[=BetaHC]{BetaHC()}} is recommended in most situations.
}
\examples{
object <- lm(QUALITY ~ NARTIC + PCTGRT + PCTSUPP, data = nas1982)
std <- BetaADF(object)
# Methods -------------------------------------------------------
print(std)
summary(std)
coef(std)
vcov(std)
confint(std, level = 0.95)

}
\references{
Browne, M. W. (1984).
Asymptotically distribution-free methods
for the analysis of covariance structures.
\emph{British Journal of Mathematical and Statistical Psychology},
\emph{37}(1), 62–83.
\doi{10.1111/j.2044-8317.1984.tb00789.x}

Dudgeon, P. (2017).
Some improvements in confidence intervals
for standardized regression coefficients.
\emph{Psychometrika}, \emph{82}(4), 928–951.
\doi{10.1007/s11336-017-9563-z}

Pesigan, I. J. A., Sun, R. W., & Cheung, S. F. (2023).
betaDelta and betaSandwich:
Confidence intervals for standardized regression coefficients in R.
\emph{Multivariate Behavioral Research}.
\doi{10.1080/00273171.2023.2201277}
}
\seealso{
Other Beta Sandwich Functions: 
\code{\link{BetaHC}()},
\code{\link{BetaN}()},
\code{\link{DiffBetaSandwich}()},
\code{\link{RSqBetaSandwich}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Beta Sandwich Functions}
\keyword{betaSandwich}
\keyword{std}
