% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyte_mfi.R
\name{calc_analyte_mfi}
\alias{calc_analyte_mfi}
\title{Calculate the analyte intensity}
\usage{
calc_analyte_mfi(
  .data,
  .parameter,
  .column_name = "analyte",
  .mean_fun = c("geometric", "harmonic", "arithmetic")
)
}
\arguments{
\item{.data}{A tidy data.frame.}

\item{.parameter}{A character giving the name of column(s) where populations
are identified.}

\item{.column_name}{A character giving the name of the column to store the
population information.}

\item{.mean_fun}{A character giving the mean function to use.}
}
\value{
A summarized \code{data.frame}
}
\description{
The mean fluorescence intensity (MFI) of the analyte
}
\section{Mean calculation}{



The calculation of the harmonic mean is as follows:
\deqn{
 n\frac{1}{\sum_{i=1}^n \frac{1}{x_i}}
}{length(x)/sum(1/x)}

\code{NA}s are removed before calculation


The geometric mean is given by:

\deqn{
  \left(\prod_{i=1}^n x_i \right)^\frac{1}{n}
}{prod(x)^(length(x))}

but implemented as:

\deqn{
  \frac{1}{n}\exp{\sum_{i=1}^n\log(x_i)}
}{exp(sum(log(x[x > 0])) / length(x))}

\code{NA}s are removed before calculation
}

\examples{
library(beadplexr)
library(dplyr)

data("lplex")

.data <- lplex[[1]] \%>\%
  filter(`FSC-A` > 4e5L, `FSC-A` < 6.3e5L) \%>\%
  identify_analyte(.parameter = "FL6-H",
                   .analyte_id = as.character(c(1:7)))

.data \%>\%
  calc_analyte_mfi(.parameter = "FL2-H")

.data \%>\%
  calc_analyte_mfi(.parameter = "FL2-H",
              .mean_fun = "harmonic")
}
