% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bma.R
\name{bma}
\alias{bma}
\title{Calculation of the bma object}
\usage{
bma(
  df,
  dep_var_col,
  timestamp_col,
  entity_col,
  model_space,
  run_parallel = FALSE,
  app = 4,
  EMS = NULL,
  dilution = 0,
  dil.Par = 0.5
)
}
\arguments{
\item{df}{Data frame with data for the SEM analysis.}

\item{dep_var_col}{Column with the dependent variable}

\item{timestamp_col}{The name of the column with timestamps}

\item{entity_col}{Column with entities (e.g. countries)}

\item{model_space}{The result of the optimal_model_space function. A matrix (with named rows)
with each column corresponding to a model. Each column specifies model parameters. Compare with \link[bdsm]{optimal_model_space}}

\item{run_parallel}{If \code{TRUE} the optimization is run in parallel using
the \link[parallel]{parApply} function. If \code{FALSE} (default value) the
base apply function is used. Note that using the parallel computing requires
setting the default cluster. See README.}

\item{app}{Parameter indicating the decimal place to which number in the BMA tables should be rounded (default app = 4)}

\item{EMS}{Expected model size for model binomial and binomial-beta model prior}

\item{dilution}{Binary parameter: 0 - NO application of a dilution prior; 1 - application of a dilution prior (George 2010).}

\item{dil.Par}{Parameter associated with dilution prior - the exponent of the determinant (George 2010). Used only if parameter dilution = 1.}
}
\value{
A list with bma objects: \cr
\enumerate{
\item uniform_table - table with the results under binomial model prior \cr
\item random_table - table with the results under binomial-beta model prior \cr
\item reg_names - vector with names of the regressors - to be used by the functions \cr
\item R - total number of regressors \cr
\item M - size of the mode space \cr
\item forJointnes - table with model IDs and PMPs for jointness function \cr
\item forBestModels - table with model IDs, PMPs, coefficients, stds, and, stdRs for best_models function \cr
\item EMS - expected model size for binomial and binomial-beta model prior specified by the user (default EMS = R/2) \cr
\item sizePriors - table with uniform and random model priors spread over model sizes for model_sizes function \cr
\item PMPs - table with posterior model probabilities for model_sizes function \cr
\item modelPriors - table with priors on models for model_pmp function \cr
\item dilution - parameter indication if priors were diluted for model_sizes function \cr
\item alphas - coefficients on lagged dependent variable for coef_hist function\cr
\item betas_nonzero - nonzero coefficients on the regressors for coef_hist function \cr
\item d_free - table with degrees of freedom of estimated models for best_models function \cr
\item PMStable - table with prior and posterior expected model size for binomial and binomial-beta model prior
}
}
\description{
This function calculates bma object for the model_space object obtained using optimal_model_space function.
It calculates BMA statistics and objects for the use by other functions.
}
\examples{
\donttest{
library(magrittr)

data_prepared <- economic_growth[,1:7] \%>\%
   feature_standardization(timestamp_col = year, entity_col = country) \%>\%
   feature_standardization(timestamp_col = year, entity_col = country,
                           time_effects = TRUE, scale = FALSE)

model_space <- optimal_model_space(df = data_prepared, dep_var_col = gdp,
                                   timestamp_col = year, entity_col = country,
                                   init_value = 0.5)

bma_results <- bma(df = data_prepared, dep_var_col = gdp, timestamp_col = year,
entity_col = country, model_space = model_space, run_parallel = FALSE, dilution = 0)
}
}
