% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simbcfrailph.R
\name{simbcfrailph}
\alias{simbcfrailph}
\title{Simulate data from bivariate correlated frailty models.}
\usage{
simbcfrailph(
  psize,
  cenr = c(0),
  beta = c(0.5),
  frailty,
  frailpar = c(0.5, 0.25),
  bhaz = c("weibull"),
  bhazpar = list(shape = c(0.5), scale = c(0.01)),
  covartype = c("B"),
  covarpar = list(fargs = c(1), sargs = c(0.5)),
  inpcovar = NULL,
  inpcen = NULL,
  comncovar = NULL
)
}
\arguments{
\item{psize}{pair size.}

\item{cenr}{censored rate. The default is zero..}

\item{beta}{Covariate coefficient.}

\item{frailty}{A type of frailty distribution to be used. Either gamma or lognormal.}

\item{frailpar}{vector of frailty parameters, variance and correlation respectively. The default is c(0.5,0.25) meaning variance 0.5 and correlation 0.25.}

\item{bhaz}{A type of baseline hazard distribution to be used. it can be weibull, gompertz or exponential.}

\item{bhazpar}{is a \code{\link{list}} containing \code{scale} and\code{shape} of the specified baseline hazard distribution.}

\item{covartype}{specified the distribution from which covariate(s) are goining to be sampled. covartype can be c("B","N","U")denoting binomial, normal or uniform, respectively. For example, \code{covartype=c("B","B")} to generate two covariates both from a binomial distribution.}

\item{covarpar}{is a \code{\link{list}} containing parmeters of the specified covariate distribution with first and second arguments denoted by \code{fargs} and \code{sargs}, respectively. For example, if \code{covartype=c("B","U")} and \code{covarpar=list(fargs=c(1,0.3),sargs=c(0.5,1.3))}, generates two independent covariates from a binomial distribution (with parameters size=1 and probs=0.5) and from uniform distributions (with parameters min=0.3 and max=1.3).}

\item{inpcovar}{is a \code{\link{list}} i.e,list(covar1=x1,covar2=x2) to input covariates with both x1 and x2 is in matrix form.}

\item{inpcen}{is a \code{\link{list}} containing \code{cent1} and \code{cent2} denoting censoring time for the first and the second subjects in pairs respectively.}

\item{comncovar}{if common covariates are needed.}
}
\value{
An object of class \code{simbcfrailph} that contain the following:

\itemize{

\item{\code{data}}  {A data frame i.e, the simulated data set. IID is individual Id, PID is pair ID, time is the simulated survival time, censor is censoring indicator and X1 denote the simulated covariate.}

\item{\code{X}}  {Covariates in Matrix form.}

\item{\code{Y}}  {A matrix contains generated survival time and censoring.}

\item{\code{numberofpair}}  {The specified number of pairs.}

\item{\code{censoredrate} } {The specified censored rate.}

\item{\code{fraildist} } {The specified frailty distribution.}

\item{\code{frailpar}} {The specified frailty parameters.}
}
}
\description{
Simulate data from bivariate correlated gamma or lognormal frailty models with or without covariates.
}
\examples{
set.seed(4)
simdata<-simbcfrailph(psize=300, cenr= c(0.3),beta=c(2),frailty=c("gamma"),
frailpar=c(0.5,0.5),bhaz=c("weibull"),
bhazpar=list(shape =c(5), scale = c(0.1)),
covartype= c("B"),covarpar=list(fargs=c(1),sargs=c(0.5)))
dataa<-simdata$data
head(dataa)

\donttest{
# If data generation is from bivariate correlated lognormal frailty model,
set.seed(18)
simdata<-simbcfrailph(psize=100, cenr= c(0.2),beta=c(1,-0.7,0.5),frailty=c("lognormal"),
frailpar=c(0.5,-0.25),bhaz=c("exponential"),
bhazpar=list(scale = c(0.1)),covartype= c("N","N","B"),
covarpar=list(fargs=c(0,0,1),sargs=c(1,1,0.5)))
dataa<-simdata$data
head(dataa)

# If common covariate is desired, i.e., here out of
#the three covariates covariate 2 is common for the pair.
set.seed(18)
simdata<-simbcfrailph(psize=100, cenr= c(0.2),beta=c(1,-0.7,0.5),frailty=c("lognormal"),
frailpar=c(0.5,-0.25),bhaz=c("exponential"),
bhazpar=list(scale = c(0.1)),covartype= c("N","N","B"),
covarpar=list(fargs=c(0,0,1),sargs=c(1,1,0.5)),comncovar=2)
dataa<-simdata$data
head(dataa)

# If the data generation is from bivariate correlated gamma
# frailty model, weibull baseline and without covariate,
set.seed(4)
simdata<-simbcfrailph(psize=300, cenr= c(0.3),beta=NULL,frailty=c("gamma"),
frailpar=c(0.5,0.5),bhaz=c("weibull"),bhazpar=list(shape =c(5), scale = c(0.1)))
dataa<-simdata$data
head(dataa)
}

}
\seealso{
\code{\link{bcfrailph}}
}
