% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write-model.R
\name{write_model_Reg_Nest}
\alias{write_model_Reg_Nest}
\title{Write \code{.bug} model file for regression model WITH nested subclasses}
\usage{
write_model_Reg_Nest(
  Mobs,
  prior,
  cause_list,
  Eti_formula,
  FPR_formula,
  use_measurements,
  ppd = NULL,
  use_jags = FALSE
)
}
\arguments{
\item{Mobs}{Measurement data in the form of \code{data_nplcm}}

\item{prior}{Prior specification from \code{model_options}}

\item{cause_list}{A list of latent status names (crucial for building templates;
see \code{\link[=make_template]{make_template()}})}

\item{Eti_formula}{Etiology regression formula; Check \code{model_options$likelihood$Eti_formula}.}

\item{FPR_formula}{A list of FPR regression formula; check
\code{model_options$likelihood$FPR_formula}}

\item{use_measurements}{"BrS", or "SS"}

\item{ppd}{Default is NULL; set to TRUE for posterior predictive checking}

\item{use_jags}{Default is FALSE; set to TRUE if want to use JAGS for model fitting.}
}
\value{
a long character string to be written into .bug file.
}
\description{
\code{write_model_Reg_Nest} automatically generates model file according to
\code{model_options}; This is called within \link{nplcm_fit_Reg_Nest}.
}
\seealso{
\link{insert_bugfile_chunk_noreg_meas} for inserting .bug file
chunk for measurements (plug-and-play.R); \link{insert_bugfile_chunk_noreg_etiology}
for inserting .bug file chunk for distribution of latent status (etiology).

Other model generation functions: 
\code{\link{write_model_NoReg}()},
\code{\link{write_model_Reg_NoNest}()},
\code{\link{write_model_Reg_discrete_predictor_NoNest}()}
}
\concept{model generation functions}
