% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bage_mod-methods.R
\name{computations}
\alias{computations}
\title{Information on Computations Performed During Model Fitting}
\usage{
computations(object)
}
\arguments{
\item{object}{A fitted object of class \code{"bage_mod"}.}
}
\value{
A \link[tibble:tibble-package]{tibble} with the following
variables:
\itemize{
\item \code{time_total} Seconds used for whole fitting process.
\item \code{time_max} Seconds used for optimisiation.
\item \code{time_draw} Seconds used by function \code{\link[TMB:sdreport]{TMB::sdreport()}}.
\item \code{iter} Number of iterations required for optimization.
\item \code{message} Message about convergence returned by optimizer.
}
}
\description{
Get information on computations performed by function \code{\link[=fit]{fit()}}.
The information includes the total time used for fitting, and
the time used for two particular tasks that can be slow:
running the optimizer \code{\link[stats:nlminb]{stats::nlminb()}},
and drawing from the multivariate normal returned
by the TMB. It also includes values returned by the optimizer:
the number of iterations needed, and messages about convergence.
}
\examples{
mod <- mod_pois(divorces ~ age + sex + time,
                data = nzl_divorces,
                exposure = population) |>
  fit()

computations(mod)
}
\seealso{
\itemize{
\item \code{\link[=mod_pois]{mod_pois()}},\code{\link[=mod_binom]{mod_binom()}},\code{\link[=mod_norm]{mod_norm()}} Specify a model
\item \code{\link[=fit]{fit()}} Fit a model
\item \code{\link[=tidy]{tidy()}} Summarise a model
\item \code{\link[=set_n_draw]{set_n_draw()}} Specify number of posterior draws
}
}
