% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import.R
\name{import}
\alias{import}
\title{Import backported functions into your package}
\usage{
import(pkgname, obj = NULL, force = FALSE)
}
\arguments{
\item{pkgname}{[\code{character(1)}]\cr
Name of the package where the backported function should be assigned.}

\item{obj}{[\code{character}]\cr
Name of objects to assign, as character vector.
If \code{NULL}, all backports which are not provided by R itself are assigned.}

\item{force}{[\code{logical}]\cr
If \code{obj} is provided and \code{force} is set to \code{FALSE}, only backports
not provided by the base package of the executing R interpreter are imported.
Set to \code{TRUE} to ignore this check and always import the backport into the package's namespace.}
}
\description{
Imports objects from \pkg{backports} into the namespace of other packages
by assigning it during load-time.
See examples for a code snippet to copy to your package.
}
\examples{
\dontrun{
# This imports all functions implemented in backports while the package is loaded
.onLoad <- function(libname, pkgname) {
  backports::import(pkgname)
}

# This only imports the function "trimws"
.onLoad <- function(libname, pkgname) {
  backports::import(pkgname, "trimws")
}

# This imports all backports from base and force-imports "hasName" from utils
.onLoad <- function(libname, pkgname) {
  backports::import(pkgname)
  backports::import(pkgname, "hasName", force = TRUE)
}
}
}
\seealso{
\code{\link[base]{.onLoad}}
}
