% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_log_config.R
\name{get_log_config}
\alias{get_log_config}
\title{Get configuration value}
\usage{
get_log_config(key = NULL)
}
\arguments{
\item{key}{Specify the key whose value needs to be extracted. \code{NULL}
implies no specific key, rather all of them to be extracted at once.}
}
\value{
Returns the respective configuration value of the given \code{key}.
If \code{key} is \code{NULL}, then all the configuration values will be
returned together as a list.
}
\description{
Get the configuration value of a specific key which was set (or not set) using
\code{\link{set_log_config}} function. If nothing was set, then it reuses the
default value defined in the function signature of
\code{\link{set_log_config}} function.
}
\examples{
  # Get configuration value without setting anything
  get_log_config("log_to_azure")
  # Set some configuration first and then get the respective values
  set_log_config(enforce_tz_utc = FALSE, log_to_azure = FALSE)
  get_log_config("enforce_tz_utc")
  get_log_config("log_to_azure")
  # Reset the values
  set_log_config()
  get_log_config("log_to_azure")

  # Extract list of all configurations
  get_log_config()

}
