/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ejb;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Path;

public class WLStop
extends Task {
    private Path classpath;
    private String username;
    private String password;
    private String serverURL;
    private int delay = 0;
    private File beaHome = null;

    public void execute() throws BuildException {
        if (this.username == null || this.password == null) {
            throw new BuildException("weblogic username and password must both be set");
        }
        if (this.serverURL == null) {
            throw new BuildException("The url of the weblogic server must be provided.");
        }
        Java weblogicAdmin = new Java((Task)this);
        weblogicAdmin.setFork(true);
        weblogicAdmin.setClassname("weblogic.Admin");
        String args = this.beaHome == null ? this.serverURL + " SHUTDOWN " + this.username + " " + this.password + " " + this.delay : " -url " + this.serverURL + " -username " + this.username + " -password " + this.password + " SHUTDOWN " + " " + this.delay;
        weblogicAdmin.createArg().setLine(args);
        weblogicAdmin.setClasspath(this.classpath);
        weblogicAdmin.execute();
    }

    public void setClasspath(Path path) {
        this.classpath = path;
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setUser(String s) {
        this.username = s;
    }

    public void setPassword(String s) {
        this.password = s;
    }

    public void setUrl(String s) {
        this.serverURL = s;
    }

    public void setDelay(String s) {
        this.delay = Integer.parseInt(s);
    }

    public void setBEAHome(File beaHome) {
        this.beaHome = beaHome;
    }
}

