% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gOverview.R
\name{gOverview}
\alias{gOverview}
\title{gOverview}
\usage{
gOverview(data_abs, data_ndd, fontFamily = NULL)
}
\arguments{
\item{data_abs}{A data frame, which contains in the first column the wave
numbers and in the following columns the samples absorbances.}

\item{data_ndd}{A data frame, which contains in the first column the wave
numbers and in the following columns the samples second derivative values.}

\item{fontFamily}{The desired graphic font family.}
}
\value{
\describe{
 \item{If \emph{data_ndd is provided}:}{It returns a grid with three plots:
  \itemize{
   \item The ensemble of all samples spectra.
   \item The ensemble of the second derivative spectra of all samples.
   \item The average and standard deviation spectra.
  }
 }
 \item{If \emph{data_ndd is omitted}:}{It returns a grid with two plots:
  \itemize{
   \item The ensemble of all samples spectra.
   \item The average and standard deviation spectra.
  }
 }
}
}
\description{
This function generates a graphic overview of the spectroscopic
  data.
}
\examples{
# Grapic overview of your raw data
gOverview(andurinhaData)

# Graphic overview of your processed data by findPeaks()
fp <- findPeaks(andurinhaData)
gOverview(fp$dataZ, fp$secondDerivative)

}
\seealso{
\code{\link{importSpectra}}, \code{\link{findPeaks}} and
  \code{\link{plotPeaks}}
}
