% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/firewalls.R
\name{as.firewall}
\alias{as.firewall}
\alias{firewalls}
\alias{firewall}
\alias{firewall_create}
\alias{firewall_update}
\title{Get list of firewalls and their metadata, or a single firewall}
\usage{
as.firewall(x)

firewalls(page = 1, per_page = 25, ...)

firewall(id, ...)

firewall_create(name, inbound_rules, outbound_rules, droplet_ids = NULL,
  tags = NULL, ...)

firewall_update(name, inbound_rules, outbound_rules, droplet_ids = NULL,
  tags = NULL, ...)
}
\arguments{
\item{x}{Object to coerce to an firewall.}

\item{page}{Page to return. Default: 1.}

\item{per_page}{Number of results per page. Default: 25.}

\item{...}{Additional arguments passed down to low-level API function
(\code{do_*})}

\item{id}{(numeric) firewall id.}

\item{name}{(character) a firewall name}

\item{inbound_rules}{(list) inbound rules}

\item{outbound_rules}{(list) outbound rules}

\item{droplet_ids}{(numeric/integer) droplet ids}

\item{tags}{(character) tag strings}
}
\description{
Get list of firewalls and their metadata, or a single firewall
}
\examples{
\dontrun{
# list firewalls
firewalls()

# create a firewall
inbound <- list(list(protocol = "tcp", ports = "80", 
  sources = list(addresses = "18.0.0.0/8")))
outbound <- list(list(protocol = "tcp", ports = "80", 
  destinations = list(addresses = "0.0.0.0/0")))
res <- firewall_create("myfirewall", inbound, outbound)
res

# get a firewall
firewall("d19b900b-b03e-4e5d-aa85-2ff8d2786f28")
as.firewall("d19b900b-b03e-4e5d-aa85-2ff8d2786f28")
}
}
