% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tags.R
\name{tag_resource_delete}
\alias{tag_resource_delete}
\title{Untag a resource}
\usage{
tag_resource_delete(name, resource_id = NULL, resource_type = "droplet",
  resources = NULL, ...)
}
\arguments{
\item{name}{(character) Name of the tag}

\item{resource_id}{(integer) a droplet id}

\item{resource_type}{(character) only "droplet" for now. Default: "droplet"}

\item{resources}{(list) instead of \code{resource_id} and \code{resource_type}
you can pass in a list to this parameter. see examples}

\item{...}{Additional options passed down to \code{\link[httr]{DELETE}}}
}
\value{
logical, \code{TRUE} if successful
}
\description{
Untag a resource
}
\examples{
\dontrun{
d <- droplet_create()
tag_resource(name = "stuffthings", resource_id = d$id, resource_type = "droplet")
## same as this because only allowed resource type right now is "droplet"
# tag_resource(name = "stuffthings", resource_id = d$id)
tag_resource_delete(name = "stuffthings", resource_id = d$id, resource_type = "droplet")
}
}

