% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track_methods.R
\name{helper}
\alias{helper}
\alias{coords}
\alias{coords.track_xy}
\alias{make_trast}
\alias{make_trast.track_xy}
\alias{extent_x}
\alias{extent_x.track_xy}
\alias{extent_y}
\alias{extent_y.track_xy}
\alias{extent_both}
\alias{extent_both.track_xy}
\alias{extent_max}
\alias{extent_max.track_xy}
\alias{range_x}
\alias{range_x.track_xy}
\alias{range_y}
\alias{range_y.track_xy}
\alias{range_both}
\alias{range_both.track_xy}
\title{Coordinates of a track.}
\usage{
coords(x, ...)

\method{coords}{track_xy}(x, ...)

make_trast(x, ...)

\method{make_trast}{track_xy}(x, factor = 1.5,
  res = extent_max(x)\%/\%100, ...)

extent_x(x, ...)

\method{extent_x}{track_xy}(x, ...)

extent_y(x, ...)

\method{extent_y}{track_xy}(x, ...)

extent_both(x, ...)

\method{extent_both}{track_xy}(x, ...)

extent_max(x, ...)

\method{extent_max}{track_xy}(x, ...)

range_x(x, ...)

\method{range_x}{track_xy}(x, ...)

range_y(x, ...)

\method{range_y}{track_xy}(x, ...)

range_both(x, ...)

\method{range_both}{track_xy}(x, ...)
}
\arguments{
\item{x}{\code{[track_xy, track_xyt]} \cr A track created with \code{make_track}.}

\item{...}{Further arguments, none implemented.}

\item{factor}{\code{[numeric(1)=1.5]{>= 1}}\cr Factor by which the extent of the relocationsis extended.}

\item{res}{\code{[numeric(1)]}\cr Resolution of the output raster.}
}
\value{
\code{[tibble]} \cr The coordinates.
}
\description{
Coordinates of a track.
}
\examples{
data(deer)
coords(deer)
}
