% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores.site.notime.R
\name{scores.site.notime}
\alias{scores.site.notime}
\title{Scores for site-level reference data that do not vary in time}
\usage{
scores.site.notime(long.name, nc.mod, ref.csv, mod.id, ref.id,
  unit.conv.mod, unit.conv.ref, variable.unit, score.weights = c(1, 2, 1,
  1, 1), rotate.me = TRUE, irregular = FALSE,
  my.projection = "+proj=longlat +ellps=WGS84",
  shp.filename = system.file("extdata/ne_110m_land/ne_110m_land.shp",
  package = "amber"), my.xlim = c(-180, 180), my.ylim = c(-60, 85),
  plot.width = 8, plot.height = 3.8, numCores = 2,
  period = c("1980-01", "2017-12"), outputDir = FALSE,
  variable.name = FALSE, meanPerGridCell = TRUE, myCex = 0.5,
  subcaption = "")
}
\arguments{
\item{long.name}{A string that gives the full name of the variable, e.g. 'Gross primary productivity'}

\item{nc.mod}{A string that gives the path and name of the netcdf file that contains the model output, e.g. '/home/model_gpp.nc'}

\item{ref.csv}{A string that gives the path and name of the csv file that contains the reference data output, e.g. '/home/reference_biomass.csv'.
The columns must be in the following order: Plot ID, longitude, latitude, data values.}

\item{mod.id}{A string that identifies the source of the reference data set, e.g. 'CanESM2'}

\item{ref.id}{A string that identifies the source of the reference data set, e.g. 'MODIS'}

\item{unit.conv.mod}{A number that is used as a factor to convert the unit of the model data, e.g. 86400}

\item{unit.conv.ref}{A number that is used as a factor to convert the unit of the reference data, e.g. 86400}

\item{variable.unit}{A string that gives the final units using LaTeX notation, e.g. 'gC m$^{-2}$ day$^{-1}$'}

\item{score.weights}{R object that gives the weights of each score (\eqn{S_{bias}}, \eqn{S_{rmse}}, \eqn{S_{phase}}, \eqn{S_{iav}}, \eqn{S_{dist}})
that are used for computing the overall score, e.g. c(1,2,1,1,1)}

\item{rotate.me}{logical: TRUE if you want longitudes to range from -180 to
180 degrees and FALSE if you want longitudes to range from 0 to 360 degrees}

\item{irregular}{logical: TRUE if data is on an irregular grid and FALSE if
data is on a regular grid}

\item{my.projection}{A string that gives the projection of the irregular grid}

\item{shp.filename}{A string that gives the coastline shapefile}

\item{my.xlim}{An R object that gives the longitude range that you wish to
plot, e.g. c(-180, 180)}

\item{my.ylim}{An R object that gives the longitude range that you wish to
plot, e.g. c(-90, 90)}

\item{plot.width}{Number that gives the plot width, e.g. 8}

\item{plot.height}{Number that gives the plot height, e.g. 4}

\item{numCores}{An integer that defines the number of cores, e.g. 2}

\item{period}{An R obect that gives the period over which to average the model data, e.g. c('1980-01', '2017-12')}

\item{outputDir}{A string that gives the output directory, e.g. '/home/project/study'. The output will only be written if the user specifies an output directory.}

\item{variable.name}{A string with the variable name, e.g. 'GPP'. If FALSE, the variable name stored in the NetCDF file will be used instead. Default is FALSE.}

\item{meanPerGridCell}{Logical. If TRUE, then values from different sites that
are located in the same grid cell are averaged. Default is set to TRUE.}

\item{myCex}{A number that determines the size of the dots in the Figure. Default is set to 0.7.}

\item{subcaption}{A string that defines the subcaption of the figure, e.g. '(a)'.}
}
\value{
(1) Figures in PDF format that show maps of the model mean, reference mean, and bias.
(2) Four text files: (i) score values and (ii) score inputs for each individual
site, and (iii) score values and (iv) score inputs averaged across sites.
}
\description{
This function compares model output against
site-level measurements such as carbon stocks. The performance of a model is
expressed through scores that range from zero to one, where increasing values
imply better performance.
Contrary to the function \link{scores.grid.time}, only two scores are computed
(bias score \eqn{S_{bias}} and spatial distribution score, \eqn{S_{dist}}) since the reference data do
not vary with time. Contrary to \link{scores.grid.time}, the bias is relative to the absolute reference mean
value rather than the reference standard deviation. Again, this is because the reference data do
not vary with time:

\eqn{(i) \ bias(\lambda, \phi)=\overline{v_{mod}}(\lambda, \phi)-\overline{v_{ref}}(\lambda, \phi)}

\eqn{(ii) \ \varepsilon_{bias}=|bias(\lambda, \phi)|/|\overline{v_{ref}}(\lambda, \phi)|}

\eqn{(iii) \ s_{bias}(\lambda, \phi)=e^{-\varepsilon_{bias}(\lambda, \phi)}}

\eqn{(iv) \ S_{bias}=\overline{\overline{s_{bias}}}}
}
\examples{
\donttest{
library(amber)
library(classInt)
library(doParallel)
library(foreach)
library(Hmisc)
library(latex2exp)
library(ncdf4)
library(parallel)
library(raster)
library(rgdal)
library(rgeos)
library(scico)
library(sp)
library(stats)
library(utils)
library(viridis)
library(xtable)

# (1) Global plots on a regular grid
long.name <- 'soil carbon'
nc.mod <- system.file('extdata/modelRegular', 'cSoil_monthly.nc', package = 'amber')
ref.csv <- system.file('extdata/siteLevelRefData', 'siteLevelDataNoTime.csv', package = 'amber')
mod.id <- 'CLASSIC' # define a model experiment ID
ref.id <- 'ABC' # give reference dataset a name
unit.conv.mod <- 1 # optional unit conversion for model data
unit.conv.ref <- 1 # optional unit conversion for reference data
variable.unit <- 'kgC m$^{-2}$' # unit after conversion (LaTeX notation)

# Short version using default settings:
scores.site.notime(long.name, nc.mod, ref.csv, mod.id, ref.id,
unit.conv.mod, unit.conv.ref, variable.unit)

# To zoom into a particular region:
scores.site.notime(long.name, nc.mod, ref.csv, mod.id, ref.id, unit.conv.mod,
unit.conv.ref, variable.unit, score.weights = c(1, 2, 1, 1, 1),
my.xlim = c(-150, -60), my.ylim = c(20, 60), plot.width = 6, plot.height = 3.8)

# (2) Regional plots on a rotated grid
nc.mod <- system.file('extdata/modelRotated', 'cSoil_monthly.nc', package = 'amber')
ref.csv <- system.file('extdata/siteLevelRefData', 'siteLevelDataNoTime.csv', package = 'amber')
mod.id <- 'CLASSIC' # define a model experiment ID
ref.id <- 'ABC' # give reference dataset a name
unit.conv.mod <- 1 # optional unit conversion for model data
unit.conv.ref <- 1 # optional unit conversion for reference data
variable.unit <- 'kgC m$^{-2}$' # unit after conversion (LaTeX notation)
rotate.me <- FALSE
irregular <- TRUE
my.projection <-'+proj=ob_tran +o_proj=longlat +o_lon_p=83. +o_lat_p=42.5 +lon_0=263.'
# shp.filename <- system.file('extdata/ne_50m_admin_0_countries/ne_50m_admin_0_countries.shp',
#  package = 'amber')
shp.filename <- system.file("extdata/ne_110m_land/ne_110m_land.shp", package = "amber")
my.xlim <- c(-171, 0) # longitude range that you wish to plot
my.ylim <- c(32, 78) # latitude range that you wish to plot
plot.width <- 7
plot.height <- 3.8
numCores <- 2

scores.site.notime(long.name, nc.mod, ref.csv, mod.id, ref.id,
unit.conv.mod, unit.conv.ref, variable.unit, rotate.me = TRUE, irregular = TRUE,
my.projection = my.projection, shp.filename = shp.filename,
my.xlim = my.xlim,  my.ylim = my.ylim, plot.width = plot.width, plot.height = plot.height)
} #donttest


}
