% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotEnsembleMean.R
\name{plotEnsembleMean}
\alias{plotEnsembleMean}
\title{Ensemble mean plots of AMBER results (bias, bias scores, etc)}
\usage{
plotEnsembleMean(long.name, metric, mod.path.list, modelIDs, myVariables,
  shp.filename = system.file("extdata/ne_110m_land/ne_110m_land.shp",
  package = "amber"), my.xlim = c(-180, 180), my.ylim = c(-60, 85),
  plot.width = 5, plot.height = 7, outputDir = FALSE,
  subcaption = "")
}
\arguments{
\item{long.name}{A string that gives the full name of the variable, e.g. 'Gross primary productivity'}

\item{metric}{A string that specifies what statistical metric should be plotted.
This includes for instance 'bias', 'crmse', 'phase', 'iav', 'bias-score', 'rmse-score', 'phase-score', and 'iav-score'.}

\item{mod.path.list}{A List of directories where AMBER output is stored for different model runs,
e.g. list(mod01.path, mod02.path, mod03.path)}

\item{modelIDs}{An R object with the different model run IDs, e.g. c('CLASSIC.CRUJRAv2', 'CLASSIC.GSWP3W5E5', 'CLASSIC.CRUNCEP')}

\item{myVariables}{An R object with the variable names of interest, e.g. c('GPP.FluxCom', 'RECO.FluxCom').}

\item{shp.filename}{A string that gives the coastline shapefile}

\item{my.xlim}{An R object that gives the longitude range that you wish to plot, e.g. c(-180, 180)}

\item{my.ylim}{An R object that gives the longitude range that you wish to plot, e.g. c(-90, 90)}

\item{plot.width}{Number that gives the plot width, e.g. 8}

\item{plot.height}{Number that gives the plot height, e.g. 4}

\item{outputDir}{A string that gives the output directory, e.g. '/home/project/study'. The output will only be written if the user specifies an output directory.}

\item{subcaption}{A string that defines the subcaption of the figure, e.g. '(a)'.}
}
\value{
Figures in PDF format.
}
\description{
This function plots ensemble mean, minimum, and maximum values of a statistical
 metric computed by \link{scores.grid.time} and \link{scores.grid.notime}.
}
\examples{
library(amber)
library(classInt)
library(doParallel)
library(foreach)
library(Hmisc)
library(latex2exp)
library(ncdf4)
library(parallel)
library(raster)
library(rgdal)
library(rgeos)
library(scico)
library(sp)
library(stats)
library(utils)
library(viridis)
library(xtable)

long.name <- 'Gross Primary Productivity'
metric <- 'mod-mean'

mod01.path <- paste(system.file('extdata', package = 'amber'), 'model01', sep = '/')
mod02.path <- paste(system.file('extdata', package = 'amber'), 'model02', sep = '/')
mod.path.list <- list(mod01.path, mod02.path)
modelIDs <- c('CLASSIC.CRUJRAv2', 'CLASSIC.GSWP3W5E5')

myVariables <- c('GPP-GOSIF', 'GPP-MODIS')

plotEnsembleMean(long.name, metric, mod.path.list, modelIDs, myVariables,
 plot.width = 5, plot.height = 5.5)

}
