% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intFun.R
\name{intFun.crmse}
\alias{intFun.crmse}
\title{Centralized root mean square error (CRMSE)}
\usage{
intFun.crmse(mod.anom, ref.anom)
}
\arguments{
\item{mod.anom}{An R object (e.g. monthly anomalies from model output)}

\item{ref.anom}{An R object (e.g. monthly anomalies from reference data)}
}
\value{
An R object that shows the centralized root mean square error
}
\description{
This function computes the centralized root mean square error,
which is defined as:

\eqn{$crmse(\lambda, \phi) = \sqrt{\frac{1}{t_{f}-t_{0}}\int_{t_{0}}^{t_{f}}[(v_{mod}(t,\lambda, \phi)-\overline{v_{mod}}(\lambda, \phi))-(v_{ref}(t,\lambda, \phi)-\overline{v_{ref}}(\lambda, \phi))]^{2}dt}$}

where \eqn{\lambda} is the longitude, \eqn{\phi} is the latitude, \eqn{t}
is the time, \eqn{t_0} is the initial time step, \eqn{t_f} is the final time
time step, \eqn{v_{mod}} is a modelled variable, \eqn{v_{ref}} is the
corresponding reference variable, \eqn{\overline{v_{mod}}} is the time-mean
modelled variable, and \eqn{\overline{v_{ref}}} is the time-mean reference
variable.
}
\examples{

library(raster)
# create two raster stacks
for(i in 1:100)
{
 mod <- raster::raster(matrix(runif(100,0,10), ncol=10))
 ref <- raster::raster(matrix(runif(100,0,10), ncol=10))
 assign(paste('mod', i , sep='_'), mod)
 assign(paste('ref', i , sep='_'), ref)
}
my.list.mod <- lapply(ls(pattern='mod_'), get)
my.list.ref <- lapply(ls(pattern='ref_'), get)
mod <- do.call(stack, my.list.mod)
ref <- do.call(stack, my.list.ref)
# compute anomalies
mod.anom <- intFun.anom(mod)
ref.anom <- intFun.anom(ref)
# compute CRMSE
crmse <- intFun.crmse(mod.anom, ref.anom)
plot(crmse); text(crmse, digits=2)

}
\keyword{internal}
