% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_bootstrap.R
\name{model_bootstrap}
\alias{model_bootstrap}
\title{model_bootstrap.R}
\usage{
model_bootstrap(
  data,
  model_call_string,
  boot_it = 100,
  seed = 0,
  boot_alpha = 0.05,
  output = c("ale", "model_stats", "model_coefs"),
  ale_options = list(),
  tidy_options = list(),
  glance_options = list()
)
}
\arguments{
\item{data}{dataframe. Dataset that will be bootstrapped.}

\item{model_call_string}{character. Character string of the full call for the model,
except that the data option must be left out. The data option will be replaced with the \code{data} argument.}

\item{boot_it}{integer from 0 to Inf. Number of bootstrap iterations.
If boot_it = 0, then the model is run as normal once on the full \code{data} with
no bootstrap.}

\item{seed}{integer. Random seed. Supply this between runs to assure identical
bootstrap samples are generated each time on the same data.}

\item{boot_alpha}{numeric. The confidence level for the bootstrap confidence intervals is
1 - boot_alpha. For example, the default 0.05 will give a 95\% confidence
interval, that is, from the 2.5\% to the 97.5\% percentile.}

\item{output}{character vector. Which types of bootstraps to calculate and return:
\itemize{
\item 'ale': Calculate and return bootstrapped ALE data and plot.
\item 'model_stats': Calculate and return bootstrapped overall model statistics.
\item 'model_coefs': Calculate and return bootstrapped model coefficients.
\item 'boot_data': Return full data for all bootstrap iterations. This data will always be calculated
because it is needed for the bootstrap averages. By default, it is not returned
except if included in this \code{output} argument.
}}

\item{ale_options, tidy_options, glance_options}{list of named arguments.
Arguments to pass to the \code{ale}, \code{broom::tidy}, or \code{broom::glance} functions, respectively,
beyond (or overriding) the defaults.}
}
\value{
list with the following elements (depending on values requested in
the \code{output} argument:
\itemize{
\item model_stats: bootstrapped results from \code{broom::glance}
\item model_coefs: bootstrapped results from \code{broom::tidy}
\item ale_data: bootstrapped ALE data and plots
\item boot_data: full bootstrap data (not returned by default)
}
}
\description{
Execute full model bootstrapping with ALE calculation on each bootstrap run
}
\details{
No modelling results, with or without ALE, should be considered reliable without
being bootstrapped.
For large datasets with clear separation between training and testing samples,
\code{ale} bootstraps the ALE results of the test data. However, when a dataset
is too small to be subdivided into training and test sets, then the entire
model should be bootstrapped. That is, multiple models should be trained,
one on each bootstrap sample. The reliable results are the average results
of all the bootstrap models, however many there are. For details, see
the vignette on small datasets or the details and examples below.

\code{model_bootstrap} automatically carries out full-model bootstrapping suitable
for small datasets. Specifically, it:
\itemize{
\item Creates multiple bootstrap samples (default 100; the user can specify any number);
\item Creates a model on each bootstrap sample;
\item Calculates model overall statistics, variable coefficients, and ALE values
for each model on each bootstrap sample;
\item Calculates the mean, median, and lower and upper confidence intervals for
each of those values across all bootstrap samples.
}
}
\examples{

# attitude dataset
attitude

## ALE for general additive models (GAM)
gam_attitude <- mgcv::gam(rating ~ s(complaints) + s(privileges) + s(learning) +
                            s(raises) + s(critical) + s(advance),
                          data = attitude)
summary(gam_attitude)

# Full model bootstrapping
# Only 5 bootstrap iterations for a rapid example
# Increase value of boot_it for more realistic results
mb_gam <- model_bootstrap(
  attitude,
  'mgcv::gam(rating ~ s(complaints) + s(privileges) + s(learning) +
               s(raises) + s(critical) + s(advance))',
  boot_it = 5
)

# Model statistics and coefficients
mb_gam$model_stats
mb_gam$model_coefs

\donttest{
# Plot ALE
mb_gam$ale_data[setdiff(names(mb_gam$ale_data), '.common_data')] |>
  purrr::map(\(.x) .x$plot) |>  # extract plots as a list
  gridExtra::grid.arrange(grobs = _, ncol = 2)
}




}
