% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Schema.R
\name{load_schema}
\alias{load_schema}
\title{Load a schema definition}
\usage{
load_schema(definition)
}
\arguments{
\item{definition}{name of the schema definition.}
}
\value{
A \link{Schema} object for the \code{definition}.
}
\description{
\code{load_schema} loads an AIRR object definition from the internal
definition set.
}
\details{
Valid definitions include:
\itemize{
  \item   \code{"Rearrangement"}
  \item   \code{"Alignment"}
  \item   \code{"Study"}
  \item   \code{"Subject"}
  \item   \code{"Diagnosis"}
  \item   \code{"Sample"}
  \item   \code{"CellProcessing"}
  \item   \code{"NucleicAcidProcessing"}
  \item   \code{"RawSequenceData"}
  \item   \code{"SoftwareProcessing"}
}
}
\examples{
# Load the Rearrangement definition
schema <- load_schema("Rearrangement")

# Load the Alignment definition
schema <- load_schema("Alignment")

}
\seealso{
See \link{Schema} for the return object.
}
