% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install_and_config.R
\name{install_py_modules}
\alias{install_py_modules}
\title{Installing necessary python modules to an environment}
\usage{
install_py_modules(
  envname = "aifeducation",
  transformer_version = "<=4.52.4",
  tokenizers_version = "<=0.21.1",
  pandas_version = "<=2.3.0",
  datasets_version = "<=3.6.0",
  codecarbon_version = "<=3.0.2",
  safetensors_version = "<=0.5.3",
  torcheval_version = "<=0.0.7",
  accelerate_version = "<=1.8.1",
  pytorch_cuda_version = "12.6",
  python_version = "3.12",
  remove_first = FALSE,
  use_conda = FALSE
)
}
\arguments{
\item{envname}{\code{string} Name of the environment where the packages should be installed.}

\item{transformer_version}{\code{string} determining the desired version of the python library 'transformers'.}

\item{tokenizers_version}{\code{string} determining the desired version of the python library 'tokenizers'.}

\item{pandas_version}{\code{string} determining the desired version of the python library 'pandas'.}

\item{datasets_version}{\code{string} determining the desired version of the python library 'datasets'.}

\item{codecarbon_version}{\code{string} determining the desired version of the python library 'codecarbon'.}

\item{safetensors_version}{\code{string} determining the desired version of the python library 'safetensors'.}

\item{torcheval_version}{\code{string} determining the desired version of the python library 'torcheval'.}

\item{accelerate_version}{\code{string} determining the desired version of the python library 'accelerate'.}

\item{pytorch_cuda_version}{\code{string} determining the desired version of 'cuda' for 'PyTorch'.
To install 'PyTorch' without cuda set to \code{NULL}.}

\item{python_version}{\code{string} Python version to use.}

\item{remove_first}{\code{bool} If \code{TRUE} removes the environment completely before recreating the environment and
installing the packages. If \code{FALSE} the packages are installed in the existing environment without any prior
changes.}

\item{use_conda}{\code{bool} If \code{TRUE} uses 'conda' for package management. If \code{FALSE} uses virtual environments for
package management.}
}
\value{
Returns no values or objects. Function is used for installing the necessary python libraries in a conda
environment.
}
\description{
Function for installing the necessary python modules.
}
\note{
Function tries to identify the type of operating system. In the case that
MAC OS is detected 'PyTorch' is installed without support for cuda.
}
\seealso{
Other Installation and Configuration: 
\code{\link{check_aif_py_modules}()},
\code{\link{install_aifeducation}()},
\code{\link{install_aifeducation_studio}()},
\code{\link{prepare_session}()},
\code{\link{set_transformers_logger}()},
\code{\link{update_aifeducation}()}
}
\concept{Installation and Configuration}
