% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gbt.convergence.R
\name{gbt.convergence}
\alias{gbt.convergence}
\title{Convergence of agtboost model.}
\usage{
gbt.convergence(object, y, x)
}
\arguments{
\item{object}{Object or pointer to object of class \code{ENSEMBLE}}

\item{y}{response vector}

\item{x}{design matrix for training. Must be of type \code{matrix}.}
}
\value{
\code{vector} with $K+1$ elements with loss at each boosting iteration and at the first constant prediction
}
\description{
\code{gbt.convergence} calculates loss of data over iterations in the model
}
\details{
Computes the loss on supplied data at each boosting iterations of the model passed as object.
This may be used to visually test for overfitting on test data, or the converce, to check for underfitting
or non-convergence.
}
\examples{
## Gaussian regression:
x_tr <- as.matrix(runif(500, 0, 4))
y_tr <- rnorm(500, x_tr, 1)
x_te <- as.matrix(runif(500, 0, 4))
y_te <- rnorm(500, x_te, 1)
mod <- gbt.train(y_tr, x_tr)
convergence <- gbt.convergence(mod, y_te, x_te)
which.min(convergence) # Should be fairly similar to boosting iterations + 1
mod$get_num_trees() +1 # num_trees does not include initial prediction

}
