% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Prior.R, R/PointMassPrior.R,
%   R/ContinuousPrior.R
\name{predictive_cdf}
\alias{predictive_cdf}
\alias{predictive_cdf,DataDistribution,PointMassPrior,numeric-method}
\alias{predictive_cdf,DataDistribution,ContinuousPrior,numeric-method}
\title{Predictive CDF}
\usage{
predictive_cdf(dist, prior, x1, n1, ...)

\S4method{predictive_cdf}{DataDistribution,PointMassPrior,numeric}(dist, prior, x1, n1, ...)

\S4method{predictive_cdf}{DataDistribution,ContinuousPrior,numeric}(
  dist,
  prior,
  x1,
  n1,
  k = 10 * (prior@support[2] - prior@support[1]) + 1,
  ...
)
}
\arguments{
\item{dist}{a univariate \code{\link[=DataDistribution-class]{distribution}} object}

\item{prior}{a \code{\link{Prior}} object}

\item{x1}{stage-one test statistic}

\item{n1}{stage-one sample size}

\item{...}{further optional arguments}

\item{k}{number of pivots for crude integral approximation}
}
\value{
\code{numeric}, value of the predictive CDF
}
\description{
\code{predictive_cdf()} evaluates the predictive CDF of the model specified
by a \code{\link{DataDistribution}} \code{dist} and
\code{\link{Prior}} at the given stage-one outcome.
}
\examples{
predictive_cdf(Normal(), PointMassPrior(.0, 1), 0, 20) # .5

tmp <- ContinuousPrior(function(x) dunif(x, .2, .4), c(.2, .4))
predictive_cdf(Normal(), tmp, 2, 20)

}
