% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GroupSequentialDesign.R
\docType{class}
\name{GroupSequentialDesign-class}
\alias{GroupSequentialDesign-class}
\alias{GroupSequentialDesign}
\alias{TwoStageDesign,GroupSequentialDesign-method}
\title{Group-sequential two-stage designs}
\usage{
GroupSequentialDesign(n1, c1f, c1e, n2_pivots, c2_pivots, order = NULL, ...)

\S4method{TwoStageDesign}{GroupSequentialDesign}(n1, ...)
}
\arguments{
\item{n1}{stage one sample size or \code{GroupSequentialDesign} object to convert
(overloaded from \code{\link{TwoStageDesign}})}

\item{c1f}{early futility stopping boundary}

\item{c1e}{early efficacy stopping boundary}

\item{n2_pivots}{numeric of length one, stage-two sample size}

\item{c2_pivots}{numeric vector, stage-two critical values on the integration
pivot points}

\item{order}{of the Gaussian uadrature rule to use for integration, set to
length(c2_pivots) if NULL, otherwise first value of c2_pivots is repeated
'order'-times.}

\item{...}{further optional arguments}
}
\description{
Group-sequential designs are a sub-class of the \code{TwoStageDesign}
class with constant stage-two sample size.
See \code{\link{TwoStageDesign}} for slot details.
Any group-sequential design can be converted to a fully flexible
\code{TwoStageDesign} (see examples section).
}
\examples{
design <- GroupSequentialDesign(25, 0, 2, 25, c(1, 1.5, 2.5))
summary(design)

TwoStageDesign(design)

}
\seealso{
\code{\link{TwoStageDesign}} for superclass and inherited methods
}
