% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activeC.R
\name{get_betagamma}
\alias{get_betagamma}
\title{Quantities for Acquisition Functions}
\usage{
get_betagamma(C, xnew, grad = FALSE)
}
\arguments{
\item{C}{A const_C object, the result of a call to C_GP}

\item{xnew}{The new design point}

\item{grad}{If \code{FALSE}, calculate beta and gamma only. If \code{TRUE}, calculate their gradient too.}
}
\value{
If \code{grad == FALSE}, A numeric vector of length 2, whose first element of beta_ij and the second gamma_ij. 
If \code{grad == TRUE}, a list with 3 numeric vector elements, the first giving the gradient for beta_ij, and the second for gamma_ij,
and the third is the same vector as would have been returned if grad was \code{FALSE}: simply the values of beta and gamma.
}
\description{
Create a single element of the BETA/GAMMA matrix. Used to compute acquisition functions and their gradients.
}
\keyword{internal}
