% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/energySIM.R
\name{energySIM}
\alias{energySIM}
\title{Runs agent-based model (ABM) movement and energy budget
simulations based on environmental data}
\usage{
energySIM(
  replicates = 100,
  days,
  modeled_species,
  env_rast,
  optimum_lo,
  optimum_hi,
  dest_x,
  dest_y,
  mot_x,
  mot_y,
  search_radius = 375,
  direction = "S",
  sigma = 0.1,
  mortality = TRUE,
  init_energy = 100,
  energy_adj = c(25, 20, 15, 10, 5, 0, -5, -10, -15, -20, -25),
  single_rast = FALSE,
  write_results = FALSE
)
}
\arguments{
\item{replicates}{Integer, desired number of replicates per run, default 100.}

\item{days}{Integer, How many days (timesteps) would you like to model? Range (1,nlayers(env_rast))}

\item{modeled_species}{Object of class "species"}

\item{env_rast}{Rasterstack or Rasterbrick with number of layers >= days}

\item{optimum_lo}{Numeric, optimal environmental value (low)}

\item{optimum_hi}{Numeric, optimal environmental value (high)}

\item{dest_x}{Numeric, destination x coordinate (longitude)}

\item{dest_y}{Numeric, destination y coordinate (latitude)}

\item{mot_x}{Numeric, movement motivation in x direction, range (0,1], default 1.}

\item{mot_y}{Numeric, movement motivation in y direction, range (0,1], default 1.}

\item{search_radius}{Radius of semicircle search regions (in km). Default 375.}

\item{direction}{Character, movement direction, one of "N","S","E","W", or "R" (Random). Default "S".}

\item{sigma}{Numeric, randomness parameter, range (-Inf, Inf). Default 0.1.}

\item{mortality}{Logical, should low energy levels result in death? Default T.}

\item{init_energy}{Numeric, initial energy in interval (0,100]}

\item{energy_adj}{Numeric, Vector of length 11 representing desired energy gain/penalty corresponding to achieved env values
in optimum range (1st element), and within 10, 20,  ..., 80, 90, and 90+ percent (11th element) of the average of optimum hi and optimum lo.
Recommend using default which is decreasing and symmetric about zero but can modify if desired.}

\item{single_rast}{Logical, are you using a one-layer raster for all timesteps?. Default F.}

\item{write_results}{Logical, save results to csv? Default F.}
}
\value{
Under "results", a (days+1 X replicates) rows X 9 column dataframe containing data on agent_id, day, longitude, latitude,
current agent status (Alive, Stopped, or Died), energy, change in energy from last time_step,
distance traveled from last timestep (in km), and final status.
Using tidy_results() provides a cleaner display of results.

Under "run_params", a record of function parameters used as well as missing_pct
and mortality_pct. missing_pct corresponds to the percent of rows in the results dataframe
missing information on lon/lat, which occurs when the agent has "died" or "stopped". mortality_pct
refers to the percentage of agents in the run that died.
}
\description{
Here, agent mortality occurs when agent reaches energy = 0. Agent energy
stores are dynamic, and affect search area as a multiplier, so movement
is directly affected by the quality of raster cells achieved. Results
may be visualized with energyVIZ(). Relies on underlying function
energySIM_helper(), which is not to be used alone.
}
\details{
For each timestep, agents can have status "Alive",
"Stopped", or "Died". All agents start alive and may stop if, on a particular
timestep, there are no non-NA raster values in the search region. This often
occurs when agents are searching over an ocean or a large lake, for example.
Once an agent stops, they remain stopped for the rest of the run. Similarly,
once an agent dies, they retain this status for all subsequent timesteps.
All timesteps with agent status "Stopped" or "Died" will have lat/lon=NA,
so as to not affect subsequent analyses.
}
\examples{
# Define species object
pop1 <- as.species(
  x = -98.7, y = 34.7)

# Run function
EX1 <- energySIM(
 replicates = 2, days = 3, env_rast = ex_raster, search_radius = 400,
 sigma = .1, dest_x = -108.6, dest_y = 26.2, mot_x = .9, mot_y = .9,
 modeled_species = pop1,
 optimum_lo = .6, optimum_hi = .8, init_energy = 100,
 direction = "R", write_results = FALSE, single_rast = TRUE, mortality = TRUE)

# View Results in Clean Format
tidy_results(EX1, type = "results")
tidy_results(EX1, type = "run_params")
}
