% Generated by roxygen2 (4.0.2): do not edit by hand
\name{pp.test}
\alias{pp.test}
\title{Phillips-Perron Test}
\usage{
pp.test(x, type = c("Z_rho", "Z_tau"), lag.short = TRUE, output = TRUE)
}
\arguments{
\item{x}{a numeric vector or univariate time series.}

\item{type}{the type of Phillips-Perron test. The default is \code{Z_rho}.}

\item{lag.short}{a logical value indicating whether the parameter of lag to calculate the
statistic is a short or long term. The default is a short term.}

\item{output}{a logical value indicating to print the results in R console. The default
is \code{TRUE}.}
}
\value{
A matrix for test results with three columns (\code{lag},\code{Z_rho}
or \code{Z_tau}, \code{p.value}) and three rows (\code{type1}, \code{type2}, \code{type3}).
Each row is the test results (including lag parameter, test statistic and p.value) for
each type of linear equation.
}
\description{
Performs the Phillips-Perron test for the null hypothesis of a unit root of
a univariate time series \code{x} (equivalently, \code{x} is a non-stationary time series).
}
\details{
Compared with the Augmented Dickey-Fuller test, Phillips-Perron test makes
correction to the test statistics and is robust to the unspecified autocorrelation
and heteroscedasticity in the errors. There are two types of test statistics,
\eqn{Z_{\rho}} and \eqn{Z_{\tau}}, which have the same asymptotic distributions
as Augmented Dickey-Fuller test statistic, \code{ADF}. The calculations of each type
of the Phillips-Perron test can be see in the reference below. If the
\code{lag.short = TRUE}, we use the default number of Newey-West lags
\eqn{floor(4*(length(x)/100)^0.25)},
otherwise \eqn{floor(12*(length(x)/100)^0.25)} to calculate the test statistics.
In order to calculate the test statistic, we consider
three types of linear regression models. The first type (\code{type1}) is the one
 with no drift and linear trend with respect to time:
\deqn{x[t] = \rho*x[t-1] + e[t],}
where \eqn{e[t]} is an error term.
The second type (\code{type2}) is the one with drift but no linear trend:
\deqn{x[t] = \mu + \rho*x[t-1] + e[t].}
The third type (type3) is the one with both drift and linear trend:
\deqn{x[t] = \mu + \alpha*t + \rho*x[t-1] + e[t].}
The p.value is calculated by the interpolation of test statistics from the critical values
tables (Table 10.A.1 for \code{Z_rho} and 10.A.2 for \code{Z_tau} in Fuller (1996))
with a given sample size \eqn{n} = length(\code{x}).
}
\note{
Missing values are removed.
}
\examples{
# PP test for ar(1) process
x <- arima.sim(list(order = c(1,0,0),ar = 0.2),n = 100)
pp.test(x)

# PP test for co2 data
pp.test(co2)
}
\author{
Debin Qiu
}
\references{
Phillips, P. C. B.; Perron, P. (1988). Testing for a Unit Root in Time Series Regression.
\emph{Biometrika}, 75 (2): 335-346.

Fuller, W. A. (1996). Introduction to statistical time series, second ed., Wiley, New York.
}
\seealso{
\code{\link{adf.test}}, \code{\link{kpss.test}}, \code{\link{stationary.test}}
}

