% Generated by roxygen2 (4.0.2): do not edit by hand
\name{kpss.test}
\alias{kpss.test}
\title{Kwiatkowski-Phillips-Schmidt-Shin Test}
\usage{
kpss.test(x, lag.short = TRUE, output = TRUE)
}
\arguments{
\item{x}{a numeric vector or univariate time series.}

\item{lag.short}{a logical value indicating whether the parameter of lag to calculate
the test statistic is a short or long term. The default is a short term. See details.}

\item{output}{a logical value indicating to print out the results in R console.
The default is \code{TRUE}.}
}
\value{
A matrix for test results with three columns (\code{lag}, \code{kpss},
\code{p.value}) and three rows (\code{type1}, \code{type2}, \code{type3}).
Each row is the test results (including lag parameter, test statistic and p.value) for
each type of linear regression models.
}
\description{
Performs Kwiatkowski-Phillips-Schmidt-Shin (KPSS) test for the null
hypothesis that \code{x} is a stationary univariate time series.
}
\details{
The Kwiatkowski-Phillips-Schmidt-Shin (KPSS) test tends to decompose the time
series into the sum of a deterministic trend, a random walk, and a stationary error:
\deqn{x[t] = \alpha*t + u[t] + e[t],}
where \eqn{u[t]} satisfies \eqn{u[t] = u[t-1] + a[t]}, and \eqn{a[t]} are i.i.d
\eqn{(0,\sigma^2)}. The null hypothesis is that \eqn{\sigma^2 = 0}, which implies
\code{x} is a stationary time series. In order to calculate the test statistic,
we consider three types of linear regression models.
The first type (\code{type1}) is the one with no drift and deterministic trend,
defined as \deqn{x[t] = u[t] + e[t].}
The second type (\code{type2}) is the one with drift but no trend:
\deqn{x[t] = \mu + u[t] + e[t].}
The third type (\code{type3}) is the one with both drift and trend:
\deqn{x[t] = \mu + \alpha*t + u[t] + e[t].}
The details of calculation of test statistic (\code{kpss}) can be seen in the references
below. The default parameter of lag to calculate the test statistic is
\eqn{max(1,floor(3*sqrt(n)/13)} for short term effect, otherwise,
\eqn{max(1,floor(10*sqrt(n)/13)} for long term effect.
The p.value is calculated by the interpolation of test statistic from tables of
critical values (Table 5, Hobijn B., Franses PH. and Ooms M (2004)) for a given
sample size \eqn{n} = length(\code{x}).
}
\note{
Missing values are removed.
}
\examples{
# KPSS test for AR(1) process
x <- arima.sim(list(order = c(1,0,0),ar = 0.2),n = 100)
kpss.test(x)

# KPSS test for co2 data
kpss.test(co2)
}
\author{
Debin Qiu
}
\references{
Hobijn B, Franses PH and Ooms M (2004). Generalization of the KPSS-test for stationarity.
\emph{Statistica Neerlandica}, vol. 58, p. 482-502.

Kwiatkowski, D.; Phillips, P. C. B.; Schmidt, P.; Shin, Y. (1992).
Testing the null hypothesis of stationarity against the alternative of a unit root.
\emph{Journal of Econometrics}, 54 (1-3): 159-178.
}
\seealso{
\code{\link{adf.test}}, \code{\link{pp.test}}, \code{\link{stationary.test}}
}

