% Generated by roxygen2 (4.0.2): do not edit by hand
\name{identify}
\alias{identify}
\title{Identify a Time Series Model}
\usage{
identify(x, p = NULL, q = NULL, nlag = 6, intercept = TRUE,
  stat.test = FALSE, method = c("adf", "pp", "kpss"), output = TRUE)
}
\arguments{
\item{x}{a numeric vector or univariate time series.}

\item{p}{the maximum lag order for AR process. The default is \code{NULL}.}

\item{q}{the maximum lag order for MA process. The default is \code{NULL}.}

\item{nlag}{the lag parameter to calculate the Ljung-Box test statistic.
The default is \code{6}.}

\item{intercept}{an intercept to be included in ARIMA model, only valid for
\code{p} > 0 or \code{q} > 0. The default is \code{TRUE}.}

\item{stat.test}{the stationary test for time series, see \code{\link{stationary.test}} for
more details. The default is \code{FALSE}.}

\item{method}{the method of stationary test, only valid for \code{stat.test = TRUE}.}

\item{output}{a logical value indicating to print the results in R console.
The default is \code{TRUE}.}
}
\value{
A list with class "\code{identify}" containing the following components:
 \item{WNcheck}{a matrix with three columns for results of white noise check for each lag.}
 \item{aicc}{the minimum AICC value, only available for \code{p > 0} or \code{q > 0}.}
 \item{min.p}{the optimal order \code{p} for AR process, only available for
 \code{p > 0} or \code{q > 0}.}
 \item{min.q}{the optimal order \code{q} for AR process, only available for
 \code{p > 0} or \code{q > 0}.}
 \item{stnt.test}{a list of stationary test results with three components. See
 \code{\link{stationary.test}} for more details.}
}
\description{
Checks the white noise and stationarity of a univariate time series,
and also identifies an appropriate ARIMA model using AICC criterion.
}
\details{
This function is similar to IDENTIFY statement in ARIMA procedure of SAS software,
which is to check the white noise and stationarity for a univariate time
series. The white noise check is accomplished by using \code{\link{Box.test}}
in \code{stats} package, with the default method \code{type = "Ljung-Box"}.
The stationary check uses the \code{\link{stationary.test}} implemented in this package.

The AICC criterion (Burnham and Anderson (2002)) is used to identify an optimal
model which has the minimum AICC value. The AICC is defined as
\deqn{AICC = AIC + 2k(k+1)/(n-k-1),}
where \eqn{AIC = 2k - 2log(Loglik)} which is called Akaike information criterion
(Akaike (1974)). Here,
\eqn{k,n} are the number of estimated parameters and observations, respectively.
\eqn{Loglik} is the maximized value of the likelihood function for the model.

Four plots are made: plot of original data, ACF plot, PACF plot and p.value of white
noise check.
}
\note{
Missing values are removed before the analysis.
}
\examples{
x <- arima.sim(list(order = c(2,0,0),ar = c(0.2,0.4)),n = 100)
identify(x) # white noise check
identify(x,stat.test = TRUE) # white noise and stationarity check
identify(x,p = 3,q = 2) # white noise check and optimal model identification.
}
\author{
Debin Qiu
}
\references{
Akaike, H. (1974), "A new look at the statistical model identification", \emph{IEEE
Transactions on Automatic Control}, 19 (6): 716-723.

Box, G. E. P. and Pierce, D. A. (1970), Distribution of residual correlations
in autoregressive-integrated moving average time series models. \emph{Journal
of the American Statistical Association}, 65, 1509-1526.

Burnham, K. P.; Anderson, D. R. (2002), Model Selection and Multimodel Inference:
A Practical Information-Theoretic Approach (2nd ed.), Springer-Verlag

Ljung, G. M. and Box, G. E. P. (1978). On a measure of lack of fit in time series
models. \emph{Biometrika} 65, 297-303.

Harvey, A. C. (1993) Time Series Models. 2nd Edition, Harvester Wheatsheaf,
NY, pp. 44, 45.
}

