% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xSimplifyNet.r
\name{xSimplifyNet}
\alias{xSimplifyNet}
\title{Function to simplify networks from an igraph object}
\usage{
xSimplifyNet(g, verbose = TRUE)
}
\arguments{
\item{g}{an "igraph" object}

\item{verbose}{logical to indicate whether the messages will be
displayed in the screen. By default, it sets to true for display}
}
\value{
an object of class "igraph"
}
\description{
\code{xSimplifyNet} is supposed to simplify networks from an igraph
object by keeping root-tip shortest paths only.
}
\note{
none
}
\examples{
\dontrun{
# Load the library
library(XGR)
}

RData.location <- "http://galahad.well.ox.ac.uk/bigdata"
\dontrun{
g <- xRDataLoader(RData.customised='ig.DO',
RData.location=RData.location)
ig <- xSimplifyNet(g)
}
}
\seealso{
\code{\link{xSimplifyNet}}
}
