% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partialFtest.R
\name{partialFtest}
\alias{partialFtest}
\title{partial F test for Wasserstein regression}
\usage{
partialFtest(reduced_res, full_res, alpha = 0.05)
}
\arguments{
\item{reduced_res}{a reduced model list returned by the \code{wass_regress} function}

\item{full_res}{a full model list returned by the \code{wass_regress} function}

\item{alpha}{type one error rate}
}
\value{
a dataframe containing the following columns:
\item{method}{methods used to compute p value, see details}
\item{statistic}{the test statistics}
\item{critical_value}{critical value}
\item{p_value}{p value of global F test}
}
\description{
partial F test for Wasserstein regression
}
\details{
two methods used to compute p value using asymptotic distribution of F statistic
\itemize{
\item{truncated:}{ asymptotic inference, p-value is obtained by truncating the infinite summation of eigenvalues into the first K terms, where the first K terms explain more than 99.99\% of the variance.}
\item{satterthwaite:}{ asymptotic inference, p-value is computed using Satterthwaite approximation method of mixtures of chi-square.}}
}
\examples{
data(strokeCTdensity)
predictor = strokeCTdensity$predictors
dSup = strokeCTdensity$densitySupport
densityCurves = strokeCTdensity$densityCurve

full_res <- wass_regress(rightside_formula = ~., Xfit_df = predictor,
 Ymat = densityCurves, Ytype = 'density', Sup = dSup)
reduced_res <- wass_regress(~ log_b_vol + b_shapInd + midline_shift + B_TimeCT, Xfit_df = predictor,
 Ymat = densityCurves, Ytype = 'density', Sup = dSup)
partialFtable = partialFtest(reduced_res, full_res, alpha = 0.05)
}
