% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{predict.WH_1d}
\alias{predict.WH_1d}
\title{Prediction for a Whittaker-Henderson Fit}
\usage{
\method{predict}{WH_1d}(object, newdata = NULL, ...)
}
\arguments{
\item{object}{An object of class \code{"WH_1d"} returned by the \code{\link[=WH_1d]{WH_1d()}} function}

\item{newdata}{A vector containing the position of new observations.
Observations from the fit will automatically be added to this, in the
adequate order}

\item{...}{Not used}
}
\value{
An object of class \code{"WH_1d"} with additional components \code{y_pred} and
\code{std_y_pred} corresponding to the model predictions and associated standard
deviations.
}
\description{
Extrapolate the Whittaker-Henderson fit for new observations.
}
\examples{
d <- portfolio_mort$d
ec <- portfolio_mort$ec

fit <- WH_1d(d, ec)
newdata = 18:99
pred <- predict(fit, newdata)
plot(pred)

}
