% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_pancan_value.R
\name{get_pancan_value}
\alias{get_pancan_value}
\alias{get_pancan_gene_value}
\title{Fetch identifier value from pan-cancer dataset}
\usage{
get_pancan_value(
  identifier,
  subtype = NULL,
  dataset = NULL,
  host = available_hosts(),
  samples = NULL
)

get_pancan_gene_value(identifier, host = "toilHub")
}
\arguments{
\item{identifier}{a length-1 character representing a gene symbol, ensembl gene id, or probe id.
Gene symbol is highly recommended.}

\item{subtype}{a length-1 chracter representing a regular expression for matching
\code{DataSubtype} column of \link[UCSCXenaTools:XenaData]{UCSCXenaTools::XenaData}.}

\item{dataset}{a length-1 chracter representing a regular expression for matching
\code{XenaDatasets} of \link[UCSCXenaTools:XenaData]{UCSCXenaTools::XenaData}.}

\item{host}{a length-1 character representing host name, e.g. "toilHub".}

\item{samples}{a character vector representing samples want to be returned.}
}
\value{
a named vector or \code{list}
}
\description{
Identifier includes gene/probe etc.
}
\section{Functions}{
\itemize{
\item \code{get_pancan_value}: Fetch identifier value from pan-cancer dataset

\item \code{get_pancan_gene_value}: Fetch gene expression value from pan-cancer dataset
}}

\examples{
\donttest{
# Fetch TP53 expression value from pan-cancer dataset
t1 <- get_pancan_value("TP53",
  dataset = "TcgaTargetGtex_rsem_isoform_tpm",
  host = "toilHub"
)
t2 <- get_pancan_gene_value("TP53")
}

}
