% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_ldavis.R
\name{to_ldavis}
\alias{to_ldavis}
\title{Create interactive visualization with LDAvis}
\usage{
to_ldavis(fitted, corpus, doc_term)
}
\arguments{
\item{fitted}{Fitted LDA Model. Object of class \link[topicmodels:TopicModel-class]{LDA})}

\item{corpus}{Document corpus. Object of class \link[quanteda:corpus]{corpus})}

\item{doc_term}{document term matrix (dtm).}
}
\value{
Invisible Object (see \link[LDAvis]{serVis})).
}
\description{
Converts \link[topicmodels:TopicModel-class]{LDA} topic model to LDAvis compatible json string and starts server.
May require \code{servr} Package to run properly. For conversion of \link[stm:stm]{STM} topic models use \link[stm]{toLDAvis}.
}
\details{
Beware that \code{to_ldavis} might fail if the corpus contains documents that consist ONLY of numbers,
emojis or punctuation e.g. do not contain a single character string. This is due to a limitation in the \code{topicmodels} package
used for model fitting that does not consider such terms as words and omits them causing the posterior to differ in length from the corpus.
If you encounter such an error, redo your pre-processing and exclude emojis, punctuation and numbers.
When using \code{\link{pool_tweets}} you can remove emojis by specifying \code{remove_emojis = TRUE}.
}
\examples{
\dontrun{

library(Twitmo)

# load tweets (included in package)
mytweets <- load_tweets(system.file("extdata", "tweets_20191027-141233.json", package = "Twitmo"))

# Pool tweets into longer pseudo-documents
pool <- pool_tweets(data = mytweets)
pooled_dfm <- pool$document_term_matrix
pooled_corp <- pool$corpus

# fit your LDA model with 7 topics
model <- fit_lda(pooled_dfm, n_topics = 7, method = "Gibbs")

# Explore your topics with LDAvis
to_ldavis(model, pooled_corp, pooled_dfm)
}
}
\seealso{
\link[stm]{toLDAvis}
}
