% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Reduce.R
\name{ReduceTrees}
\alias{ReduceTrees}
\title{Collapse areas of agreement between two trees}
\usage{
ReduceTrees(tree1, tree2, check = TRUE)
}
\arguments{
\item{tree1, tree2}{Single trees of class \code{phylo} to undergo comparison.}

\item{check}{Logical specifying whether to validate input. Specify
\code{FALSE} and you will encounter undefined behaviour if trees are not
binary \code{phylo} objects with identical leaf labels, rooted on leaf 1.}
}
\value{
\code{ReduceTrees()} returns a list of two trees, corresponding to
\code{tree1} and \code{tree2} after any identical groupings have been collapsed,
with tree edges listed in postorder; or \code{NULL} if the trees are equivalent.
}
\description{
\code{ReduceTrees()} reduces trees according to the tree reduction rules of
\insertCite{Allen2001;textual}{TreeDist}:
\itemize{
\item Collapse identical pendant subtrees;
\item Compress equivalent internal chains.
}
}
\examples{
tree1 <- TreeTools::BalancedTree(9)
tree2 <- TreeTools::PectinateTree(9)

# Set graphical parameters
oPar <- par(mai = rep(0.1, 4), mfrow = c(2, 2))

plot(tree1)
plot(tree2)

# Reduce trees by collapsing identical clades
confl <- ReduceTrees(tree1, tree2)

plot(confl[[1]])
plot(confl[[2]])

# Restore graphical parameters
par(oPar)
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
