% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basicfcts_TS.R
\name{rNTS}
\alias{rNTS}
\title{Function to generate random variates of NTS distribution.}
\usage{
rNTS(
  n,
  alpha = NULL,
  beta = NULL,
  delta = NULL,
  lambda = NULL,
  mu = NULL,
  theta = NULL,
  methodR = "AR",
  k = 10000
)
}
\arguments{
\item{n}{sample size (integer).}

\item{alpha}{A real number between 0 and 1.}

\item{beta}{A gap holder.}

\item{delta}{A real number > 0.}

\item{lambda}{A  real number > 0.}

\item{mu}{A location parameter, any real number.}

\item{theta}{A vector of all other arguments.}

\item{methodR}{A String. Either "AR" or "SR". "AR" by default.}

\item{k}{integer: the number of replications, if \code{methodR == "SR"}. 10000
by default.}
}
\value{
Generates \code{n} random numbers.
}
\description{
Generates \code{n} random numbers distributed according
of the normal tempered stable distribution.
}
\details{
\code{theta} denotes the parameter vector \code{(alpha, beta, delta, lambda,
mu)}. Either provide the parameters individually OR provide \code{theta}.
Works by a normal variance-mean mixture with a TSS distribution. Method
parameter is for the method of simulating the TSS random variable, see the
\code{\link[=rTSS]{rTSS()}} function.
"AR" stands for the Acceptance-Rejection Method and "SR" for a truncated
infinite shot noise series representation. "AR" is the standard method used.

For more details, see references.
}
\examples{
rNTS(100, 0.5, 1,1,1,1)
rNTS(10, 0.6, 0,1,1,0)
rNTS(10, 0.5, 1,1,1,1, NULL, "SR", 100)

}
\references{
Massing, T. (2023), 'Parametric Estimation of Tempered Stable Laws'

Kawai, R & Masuda, H (2011), 'On simulation of tempered stable random
variates' \doi{10.1016/j.cam.2010.12.014}
}
\seealso{
See also the \code{\link[=rTSS]{rTSS()}} function.
}
