\name{MRT.Size}
\alias{MRT.Size}
\title{Univariate regression tree with constrain on the group number}
\description{
Partitioning (with a time contiguity constraint) the data using an arbitrary tree size number. The function uses \code{mvpart} as a basic function to persue the univariate tree analyses (from the \pkg{mvpart} package).
}
\usage{
MRT.Size(mrt.x, mrt.y, data, Size, Graph = FALSE, Habitat1 = FALSE, Habitat2 = FALSE)
}
\arguments{
  \item{mrt.x}{
Column name for the chronological values to be used as a time contiguity constraint, typically the distance to the nucleus. Data in this colum must be numeric.}
  \item{mrt.y}{
Column name for the elemental concentration to be used. Data in this column must be numeric.}
  \item{data}{ Dataframe to be analysed.}
  \item{Size}{Size of the requested tree to be obtained (number og groups).}
  \item{Graph}{Optional supplementary graphs depicting apparent and relative (cross-validated) R-squares according to tree sizes, up to \code{Size}.}
  \item{Habitat1}{Plot habitat use according to the given threshold.}
  \item{Habitat2}{Plot habitat use according to the two given thresholds.}
}
\details{
\bold{Pruning} \cr
The function allows partitioning (stepwise constant model only) the data using an arbitrary tree size number (in an MRT context, tree size refers to the number of terminal nodes (groups) to be obtained). A major task in tree-based approaches is selecting the optimal tree size as the partition must be optimal in terms of model fitting (predictive error) and model simplicity (tree size). To deal with this optimization issue, tree algorithms typically calculate the fully grown tree (i.e. numerous terminal groups with very few measurements) and then prune the lower branches on the basis of v-fold cross-validation error (the selected tree size minimizes the cross-validated error based on the '1se' rule, see \code{\link{mvpart}}. This can be easily performed by omitting the \code{Size} argument.

\bold{Graphic} \cr
In the figure each group is characterized by its mean +- 1 SD and is displayed using a unique colour. The consol also display the internal splits selected by the algorithm.
\cr

\bold{Habitat} \cr The conventional approach often consists in qualitatively analyzing the trend of chemical concentrations and comparing this trend with threshold(s) established for discriminating between habitats. In this context, two thresholds can be used: one under which signal would typically be considered as residency in "habitat 1" (e.g. freshwater) and one over which signal would typically be considered as residency in "habitat 2" (e.g. marine). This is done using the \code{habitat2} argument. The presence of fish in one of the two provided habitats is establish according to the Mean +- 1SD of each group generated by the tree model. For each group, if the Mean - 1SD is higher than the highest threshold, measurements of the whole group is attributed to one habitat. If the Mean + 1SD is lower than the lowest threshold, measurements of the whole group is attributed to the other habitat. If any Mean +- 1SD values contain a threshold or exhibit intermediate values (i.e. between the two values provided), the whole group appears as "unassigned". Please, note that the two threshold values must be concatenated using the \code{c()} function,and preferably ordered increasingly. In case the user can't define two distinct thresholds, the functions also allow using one threshold value that separate two habitats using the \code{Habitat1} argument. When using either \code{Habitat1} or \code{Habitat2} argument, the associated threshold(s) are automatically plotted in the figure using dotted line(s).
}
\value{
A list including the following elements:
\item{Change}{Values of internal splits (as appearing in the consol).}
\item{Model}{An object of class \code{rpart} created by the \code{mvpart} function from the \pkg{mvpart} package.}
\item{Mean}{Means for each group (groups are organized chronologically, from 1 to \code{Size}).}
\item{SD}{Standard deviation for each group (still organized chronologically).}
\item{Belong}{The group belonging for each initial observations (same length as \code{mrt.x}).}
\item{N}{The sequential number of observations in each group.}
\item{Predict}{The predicted values (stepwise constant model).}
\item{Size}{The real tree size created by the \code{mvpart} function.}
\item{outpout}{Text for \code{summary.MRT}}
\item{X}{Original \code{mrt.x} values}
\item{Y}{Original \code{mrt.y} values}
}


\section{Warning }{While the model is forced to obtain the requested \code{Size}, the basic \code{mvpart} function return in certain (rare) circumstances a parcimonious tree (a tree of size \code{Size}-1 instead of the requested \code{Size}). This generally appears when the last split of the demanded tree size does not decrease the overall lack of fit by a significant manner.}

\seealso{
\code{\link{mvpart}}, \code{\link{MRT.AllSize}}, \code{\link{MRT.All}}
}

\examples{
data(univar)
# For constrained partition
model<-MRT.Size("Distance", "Sr:Ca", univar, Size=3)
model$Mean;model$SD
#summary.MRT(model)
# For unconstrained partition. Pruning is based on cross-validation.
model2<-MRT.Size("Distance", "Sr:Ca", univar)
plot(model2$Model)
text(model2$Model)
}
\keyword{univariate}
