% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_party.R
\name{parse_party}
\alias{parse_party}
\title{parse_party}
\usage{
parse_party(tree, data = NULL, include_subgroups = FALSE, digits = NULL)
}
\arguments{
\item{tree}{An object of class BinaryTree or mob resulting from a call to the
ctree() or mob() function.}

\item{data}{data.frame containing covariates used to create tree.}

\item{include_subgroups}{A logical value indicating whether or not to include
a string representation of the subgroups in the results. Defaults to FALSE.}

\item{digits}{Number of digits for rounding.}
}
\value{
A data.frame containing a parsed tree.
}
\description{
Parse output from ctree() and mob() functions in party package.
}
\details{
Collects text output from party::ctree() or party::mob(), parses the
splits, and populates a data.frame with the relevant data.
}
\examples{
requireNamespace( "party", quietly = TRUE )
requireNamespace( "modeltools", quietly = TRUE )
## From party::ctree() examples:
set.seed(290875)
## regression
airq <- subset(airquality, !is.na(Ozone))
airct <- party::ctree(Ozone ~ ., data = airq, 
               controls = party::ctree_control(maxsurrogate = 3))

## Parse the results into a new data.frame
ex1 <- parse_party( airct )
ex1

## From party::mob() examples:
data("BostonHousing", package = "mlbench")
## and transform variables appropriately (for a linear regression)
BostonHousing$lstat <- log(BostonHousing$lstat)
BostonHousing$rm <- BostonHousing$rm^2
## as well as partitioning variables (for fluctuation testing)
BostonHousing$chas <- factor( BostonHousing$chas, levels = 0:1, 
                              labels = c("no", "yes") )
BostonHousing$rad <- factor(BostonHousing$rad, ordered = TRUE)

## partition the linear regression model medv ~ lstat + rm
## with respect to all remaining variables:
fmBH <- party::mob( medv ~ lstat + rm | zn + indus + chas + nox + age + 
             dis + rad + tax + crim + b + ptratio,
             control = party::mob_control(minsplit = 40), data = BostonHousing, 
             model = modeltools::linearModel )

## Parse the results into a new data.frame
ex2 <- parse_party( fmBH )
ex2
}
\seealso{
\link[party]{ctree}, \link[party]{mob}
}
