% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SL.qda.R
\name{SL.qda}
\alias{SL.qda}
\title{SL wrapper for MASS:qda}
\usage{
SL.qda(Y, X, newX, family, obsWeights = rep(1, nrow(X)), verbose = F,
  id = NULL, prior = as.vector(prop.table(table(Y))), method = "mle",
  tol = 1e-04, CV = F, nu = 5, ...)
}
\arguments{
\item{Y}{Outcome variable}

\item{X}{Training dataframe}

\item{newX}{Test dataframe}

\item{family}{Binomial only, cannot be used for regression.}

\item{obsWeights}{Observation-level weights}

\item{verbose}{If TRUE, display additional output during execution.}

\item{id}{Not supported.}

\item{prior}{the prior probabilities of class membership. If unspecified, the
class proportions for the training set are used. If present, the
probabilities should be specified in the order of the factor levels.}

\item{method}{"moment" for standard estimators of the mean and variance,
"mle" for MLEs, "mve" to use cov.mve, or "t" for robust estimates based on
a t distribution.}

\item{tol}{tolerance}

\item{CV}{If true, returns results (classes and posterior probabilities) for
leave-one-out cross-validation. Note that if the prior is estimated, the
proportions in the whole dataset are used.}

\item{nu}{degrees of freedom for method = "t".}

\item{...}{Any additional arguments, not currently used.}
}
\description{
Quadratic discriminant analysis, used for classification.
}
\examples{

data(Boston, package = "MASS")
Y = as.numeric(Boston$medv > 23)
# Remove outcome from covariate dataframe.
X = Boston[, -14]

set.seed(1)

# Use only 2 CV folds to speed up example.
sl = SuperLearner(Y, X, family = binomial(), cvControl = list(V = 2),
                 SL.library = c("SL.mean", "SL.qda"))
sl

pred = predict(sl, X)
summary(pred$pred)


}
\references{
James, G., Witten, D., Hastie, T., & Tibshirani, R. (2013). An Introduction
to Statistical Learning (Vol. 6). New York: Springer. Section 4.4.
}
\seealso{
\code{\link{predict.SL.qda}} \code{\link[MASS]{qda}}
  \code{\link[MASS]{predict.qda}} \code{\link{SL.lda}}
}
