% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SL.lm.R
\name{SL.lm}
\alias{SL.lm}
\title{Wrapper for lm}
\usage{
SL.lm(Y, X, newX, family, obsWeights, model = TRUE, ...)
}
\arguments{
\item{Y}{Outcome variable}

\item{X}{Training dataframe}

\item{newX}{Test dataframe}

\item{family}{Gaussian or binomial}

\item{obsWeights}{Observation-level weights}

\item{model}{Whether to save model.matrix of data in fit object. Set to FALSE
to save memory.}

\item{...}{Any remaining arguments, not used.}
}
\description{
Wrapper for OLS via lm(), which may be faster than glm().
}
\examples{

data(Boston, package = "MASS")
Y = Boston$medv
# Remove outcome from covariate dataframe.
X = Boston[, -14]

set.seed(1)

sl = SuperLearner(Y, X, family = gaussian(),
                  SL.library = c("SL.mean", "SL.lm"))

print(sl)

}
\references{
Fox, J. (2015). Applied regression analysis and generalized linear models.
Sage Publications.
}
\seealso{
\code{\link{predict.SL.lm}} \code{\link[stats]{lm}}
  \code{\link[stats]{predict.lm}}  \code{\link{SL.speedlm}}
}
