% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{steiner_comparison_plots}
\alias{steiner_comparison_plots}
\title{Plot simulated data}
\usage{
steiner_comparison_plots(type, method, data, outputname)
}
\arguments{
\item{type}{a character vector, which indicates types of algorithms to analyse. Can be
"EXA", "SP", "KB", "RSP", "SPM" or "ASP".}

\item{method}{a character vector; specifies a calculated parameter based on which comparison is performed. Can be 
"runtime" (for time of execution), "log10runtime", "edge" (for number of edges in resultant steiner tree),
"log10edge", "ter_freq" (for terminal frequency in resultant steiner tree) or "edge_dens" (for edge density
in resultant steiner tree).}

\item{data}{should have structure as output of steiner_simulation function.}

\item{outputname}{a character scalar; name of file in which the result is stored}
}
\value{
For each method a plot with comparison of algorithms (pointed in type variable) is created.
        An additional information about the number of experiments and number of terminals
        for each type of algorithm is added. If the number of terminals is the same for each type,
        then their number is printed, otherwise the range is printed.
}
\description{
This function plots the comparison results of simulated data and stores it in PDF file.
}
\examples{
g <- graph("Cubical")

data <- steiner_simulation(type = c("SP", "KB", "SPM"),
                           graph = g,
                           ter_list = generate_st_samples(graph = g,
                                                          ter_number = c(2, 3),
                                                          prob = c(0.1, 0.2)))

steiner_comparison_plots(type = c("SP", "KB"),
                         method = c("runtime", "ter_freq"),
                         data = data,
                         outputname = "plot1.pdf")

}
\references{
1. Afshin Sadeghi and Holger Froehlich, "Steiner tree methods for optimal sub-network
               identification: an empirical study", BMC Bioinformatics 2013 14:144
}
\seealso{
\code{\link{generate_st_samples}}, \code{\link{steiner_simulation}}, \code{\link{steinertree}}
}
