% Generated by roxygen2 (4.0.1): do not edit by hand
\name{interaction.test}
\alias{interaction.test}
\title{Test for Interaction of Ranking Data}
\usage{
interaction.test(X)
}
\arguments{
\item{X}{a I * J * N array, two-factor design dataset.
X[i, j, n] denotes the response of the n-th replicate in the (i, j) cell .}
}
\value{
a list of test statistic and the p value
}
\description{
This function performs a test of interaction of ranking data.
}
\examples{
# Box-cox data revisited
# See Box, G. and Cox, D. (1964). An analysis of transformations.
boxcoxdat = array(0, c(3, 4, 4))
boxcoxdat[1, , ] =
    matrix(c(
        0.31, 0.82, 0.43, 0.45,
        0.45, 1.10, 0.45, 0.71,
        0.46, 0.88, 0.63, 0.66,
        0.43, 0.72, 0.76, 0.62), nrow = 4)
boxcoxdat[2, , ] =
    matrix(c(
        0.36, 0.92, 0.44, 0.56,
        0.29, 0.61, 0.35, 1.02,
        0.40, 0.49, 0.31, 0.71,
        0.23, 1.24, 0.40, 0.38), nrow = 4)
boxcoxdat[3, , ] =
    matrix(c(
        0.22, 0.30, 0.23, 0.30,
        0.21, 0.37, 0.25, 0.36,
        0.18, 0.38, 0.24, 0.31,
        0.23, 0.29, 0.22, 0.33), nrow = 4)
interaction.test(boxcoxdat)
}
\author{
Li Qinglong <liqinglong0830@163.com>
}
\references{
A Nonparametric test for interaction in two-way layouts, Xin Gao and Mayer Alvo
}

