% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/functions.R
\docType{methods}
\name{column_string_functions}
\alias{column_string_functions}
\alias{ascii,Column-method}
\alias{ascii}
\alias{base64,Column-method}
\alias{base64}
\alias{decode,Column,character-method}
\alias{decode}
\alias{encode,Column,character-method}
\alias{encode}
\alias{initcap,Column-method}
\alias{initcap}
\alias{length,Column-method}
\alias{length}
\alias{lower,Column-method}
\alias{lower}
\alias{ltrim,Column,missing-method}
\alias{ltrim}
\alias{ltrim,Column,character-method}
\alias{rtrim,Column,missing-method}
\alias{rtrim}
\alias{rtrim,Column,character-method}
\alias{soundex,Column-method}
\alias{soundex}
\alias{trim,Column,missing-method}
\alias{trim}
\alias{trim,Column,character-method}
\alias{unbase64,Column-method}
\alias{unbase64}
\alias{upper,Column-method}
\alias{upper}
\alias{levenshtein,Column-method}
\alias{levenshtein}
\alias{instr,Column,character-method}
\alias{instr}
\alias{format_number,Column,numeric-method}
\alias{format_number}
\alias{concat_ws,character,Column-method}
\alias{concat_ws}
\alias{format_string,character,Column-method}
\alias{format_string}
\alias{locate,character,Column-method}
\alias{locate}
\alias{lpad,Column,numeric,character-method}
\alias{lpad}
\alias{regexp_extract,Column,character,numeric-method}
\alias{regexp_extract}
\alias{regexp_replace,Column,character,character-method}
\alias{regexp_replace}
\alias{rpad,Column,numeric,character-method}
\alias{rpad}
\alias{substring_index,Column,character,numeric-method}
\alias{substring_index}
\alias{translate,Column,character,character-method}
\alias{translate}
\alias{split_string,Column,character-method}
\alias{split_string}
\alias{split_string,Column-method}
\alias{repeat_string,Column,numeric-method}
\alias{repeat_string}
\alias{repeat_string,Column-method}
\title{String functions for Column operations}
\usage{
ascii(x)

base64(x)

concat_ws(sep, x, ...)

decode(x, charset)

encode(x, charset)

format_number(y, x)

format_string(format, x, ...)

initcap(x)

instr(y, x)

levenshtein(y, x)

locate(substr, str, ...)

lower(x)

lpad(x, len, pad)

ltrim(x, trimString)

regexp_extract(x, pattern, idx)

regexp_replace(x, pattern, replacement)

repeat_string(x, n)

rpad(x, len, pad)

rtrim(x, trimString)

split_string(x, pattern)

soundex(x)

substring_index(x, delim, count)

translate(x, matchingString, replaceString)

trim(x, trimString)

unbase64(x)

upper(x)

\S4method{ascii}{Column}(x)

\S4method{base64}{Column}(x)

\S4method{decode}{Column,character}(x, charset)

\S4method{encode}{Column,character}(x, charset)

\S4method{initcap}{Column}(x)

\S4method{length}{Column}(x)

\S4method{lower}{Column}(x)

\S4method{ltrim}{Column,missing}(x, trimString)

\S4method{ltrim}{Column,character}(x, trimString)

\S4method{rtrim}{Column,missing}(x, trimString)

\S4method{rtrim}{Column,character}(x, trimString)

\S4method{soundex}{Column}(x)

\S4method{trim}{Column,missing}(x, trimString)

\S4method{trim}{Column,character}(x, trimString)

\S4method{unbase64}{Column}(x)

\S4method{upper}{Column}(x)

\S4method{levenshtein}{Column}(y, x)

\S4method{instr}{Column,character}(y, x)

\S4method{format_number}{Column,numeric}(y, x)

\S4method{concat_ws}{character,Column}(sep, x, ...)

\S4method{format_string}{character,Column}(format, x, ...)

\S4method{locate}{character,Column}(substr, str, pos = 1)

\S4method{lpad}{Column,numeric,character}(x, len, pad)

\S4method{regexp_extract}{Column,character,numeric}(x, pattern, idx)

\S4method{regexp_replace}{Column,character,character}(x, pattern,
  replacement)

\S4method{rpad}{Column,numeric,character}(x, len, pad)

\S4method{substring_index}{Column,character,numeric}(x, delim, count)

\S4method{translate}{Column,character,character}(x, matchingString,
  replaceString)

\S4method{split_string}{Column,character}(x, pattern)

\S4method{repeat_string}{Column,numeric}(x, n)
}
\arguments{
\item{x}{Column to compute on except in the following methods:
\itemize{
\item \code{instr}: \code{character}, the substring to check. See 'Details'.
\item \code{format_number}: \code{numeric}, the number of decimal place to
     format to. See 'Details'.
}}

\item{sep}{separator to use.}

\item{...}{additional Columns.}

\item{charset}{character set to use (one of "US-ASCII", "ISO-8859-1", "UTF-8", "UTF-16BE",
"UTF-16LE", "UTF-16").}

\item{y}{Column to compute on.}

\item{format}{a character object of format strings.}

\item{substr}{a character string to be matched.}

\item{str}{a Column where matches are sought for each entry.}

\item{len}{maximum length of each output result.}

\item{pad}{a character string to be padded with.}

\item{trimString}{a character string to trim with}

\item{pattern}{a regular expression.}

\item{idx}{a group index.}

\item{replacement}{a character string that a matched \code{pattern} is replaced with.}

\item{n}{number of repetitions.}

\item{delim}{a delimiter string.}

\item{count}{number of occurrences of \code{delim} before the substring is returned.
A positive number means counting from the left, while negative means
counting from the right.}

\item{matchingString}{a source string where each character will be translated.}

\item{replaceString}{a target string where each \code{matchingString} character will
be replaced by the character in \code{replaceString}
at the same location, if any.}

\item{pos}{start position of search.}
}
\description{
String functions defined for \code{Column}.
}
\details{
\code{ascii}: Computes the numeric value of the first character of the string column,
and returns the result as an int column.

\code{base64}: Computes the BASE64 encoding of a binary column and returns it as
a string column. This is the reverse of unbase64.

\code{decode}: Computes the first argument into a string from a binary using the provided
character set.

\code{encode}: Computes the first argument into a binary from a string using the provided
character set.

\code{initcap}: Returns a new string column by converting the first letter of
each word to uppercase. Words are delimited by whitespace. For example, "hello world"
will become "Hello World".

\code{length}: Computes the character length of a string data or number of bytes
of a binary data. The length of string data includes the trailing spaces.
The length of binary data includes binary zeros.

\code{lower}: Converts a string column to lower case.

\code{ltrim}: Trims the spaces from left end for the specified string value. Optionally a
\code{trimString} can be specified.

\code{rtrim}: Trims the spaces from right end for the specified string value. Optionally a
\code{trimString} can be specified.

\code{soundex}: Returns the soundex code for the specified expression.

\code{trim}: Trims the spaces from both ends for the specified string column. Optionally a
\code{trimString} can be specified.

\code{unbase64}: Decodes a BASE64 encoded string column and returns it as a binary column.
This is the reverse of base64.

\code{upper}: Converts a string column to upper case.

\code{levenshtein}: Computes the Levenshtein distance of the two given string columns.

\code{instr}: Locates the position of the first occurrence of a substring (\code{x})
in the given string column (\code{y}). Returns null if either of the arguments are null.
Note: The position is not zero based, but 1 based index. Returns 0 if the substring
could not be found in the string column.

\code{format_number}: Formats numeric column \code{y} to a format like '#,###,###.##',
rounded to \code{x} decimal places with HALF_EVEN round mode, and returns the result
as a string column.
If \code{x} is 0, the result has no decimal point or fractional part.
If \code{x} < 0, the result will be null.

\code{concat_ws}: Concatenates multiple input string columns together into a single
string column, using the given separator.

\code{format_string}: Formats the arguments in printf-style and returns the result
as a string column.

\code{locate}: Locates the position of the first occurrence of substr.
Note: The position is not zero based, but 1 based index. Returns 0 if substr
could not be found in str.

\code{lpad}: Left-padded with pad to a length of len.

\code{regexp_extract}: Extracts a specific \code{idx} group identified by a Java regex,
from the specified string column. If the regex did not match, or the specified group did
not match, an empty string is returned.

\code{regexp_replace}: Replaces all substrings of the specified string value that
match regexp with rep.

\code{rpad}: Right-padded with pad to a length of len.

\code{substring_index}: Returns the substring from string (\code{x}) before \code{count}
occurrences of the delimiter (\code{delim}). If \code{count} is positive, everything the left of
the final delimiter (counting from left) is returned. If \code{count} is negative, every to the
right of the final delimiter (counting from the right) is returned. \code{substring_index}
performs a case-sensitive match when searching for the delimiter.

\code{translate}: Translates any character in the src by a character in replaceString.
The characters in replaceString is corresponding to the characters in matchingString.
The translate will happen when any character in the string matching with the character
in the matchingString.

\code{split_string}: Splits string on regular expression.
Equivalent to \code{split} SQL function.

\code{repeat_string}: Repeats string n times.
Equivalent to \code{repeat} SQL function.
}
\note{
ascii since 1.5.0

base64 since 1.5.0

decode since 1.6.0

encode since 1.6.0

initcap since 1.5.0

length since 1.5.0

lower since 1.4.0

ltrim since 1.5.0

ltrim(Column, character) since 2.3.0

rtrim since 1.5.0

rtrim(Column, character) since 2.3.0

soundex since 1.5.0

trim since 1.5.0

trim(Column, character) since 2.3.0

unbase64 since 1.5.0

upper since 1.4.0

levenshtein since 1.5.0

instr since 1.5.0

format_number since 1.5.0

concat_ws since 1.5.0

format_string since 1.5.0

locate since 1.5.0

lpad since 1.5.0

regexp_extract since 1.5.0

regexp_replace since 1.5.0

rpad since 1.5.0

substring_index since 1.5.0

translate since 1.5.0

split_string 2.3.0

repeat_string since 2.3.0
}
\examples{
\dontrun{
# Dataframe used throughout this doc
df <- createDataFrame(as.data.frame(Titanic, stringsAsFactors = FALSE))}

\dontrun{
head(select(df, ascii(df$Class), ascii(df$Sex)))}

\dontrun{
tmp <- mutate(df, s1 = encode(df$Class, "UTF-8"))
str(tmp)
tmp2 <- mutate(tmp, s2 = base64(tmp$s1), s3 = decode(tmp$s1, "UTF-8"),
                    s4 = soundex(tmp$Sex))
head(tmp2)
head(select(tmp2, unbase64(tmp2$s2)))}

\dontrun{
tmp <- mutate(df, sex_lower = lower(df$Sex), age_upper = upper(df$age),
                  sex_age = concat_ws(" ", lower(df$sex), lower(df$age)))
head(tmp)
tmp2 <- mutate(tmp, s1 = initcap(tmp$sex_lower), s2 = initcap(tmp$sex_age),
                    s3 = reverse(df$Sex))
head(tmp2)}

\dontrun{
tmp <- mutate(df, SexLpad = lpad(df$Sex, 6, " "), SexRpad = rpad(df$Sex, 7, " "))
head(select(tmp, length(tmp$Sex), length(tmp$SexLpad), length(tmp$SexRpad)))
tmp2 <- mutate(tmp, SexLtrim = ltrim(tmp$SexLpad), SexRtrim = rtrim(tmp$SexRpad),
                    SexTrim = trim(tmp$SexLpad))
head(select(tmp2, length(tmp2$Sex), length(tmp2$SexLtrim),
                  length(tmp2$SexRtrim), length(tmp2$SexTrim)))

tmp <- mutate(df, SexLpad = lpad(df$Sex, 6, "xx"), SexRpad = rpad(df$Sex, 7, "xx"))
head(tmp)}

\dontrun{
tmp <- mutate(df, d1 = levenshtein(df$Class, df$Sex),
                  d2 = levenshtein(df$Age, df$Sex),
                  d3 = levenshtein(df$Age, df$Age))
head(tmp)}

\dontrun{
tmp <- mutate(df, s1 = instr(df$Sex, "m"), s2 = instr(df$Sex, "M"),
                  s3 = locate("m", df$Sex), s4 = locate("m", df$Sex, pos = 4))
head(tmp)}

\dontrun{
tmp <- mutate(df, v1 = df$Freq/3)
head(select(tmp, format_number(tmp$v1, 0), format_number(tmp$v1, 2),
                 format_string("\%4.2f \%s", tmp$v1, tmp$Sex)), 10)}

\dontrun{
# concatenate strings
tmp <- mutate(df, s1 = concat_ws("_", df$Class, df$Sex),
                  s2 = concat_ws("+", df$Class, df$Sex, df$Age, df$Survived))
head(tmp)}

\dontrun{
tmp <- mutate(df, s1 = regexp_extract(df$Class, "(\\\\d+)\\\\w+", 1),
                  s2 = regexp_extract(df$Sex, "^(\\\\w)\\\\w+", 1),
                  s3 = regexp_replace(df$Class, "\\\\D+", ""),
                  s4 = substring_index(df$Sex, "a", 1),
                  s5 = substring_index(df$Sex, "a", -1),
                  s6 = translate(df$Sex, "ale", ""),
                  s7 = translate(df$Sex, "a", "-"))
head(tmp)}

\dontrun{
head(select(df, split_string(df$Sex, "a")))
head(select(df, split_string(df$Class, "\\\\d")))
# This is equivalent to the following SQL expression
head(selectExpr(df, "split(Class, '\\\\\\\\d')"))}

\dontrun{
head(select(df, repeat_string(df$Class, 3)))
# This is equivalent to the following SQL expression
head(selectExpr(df, "repeat(Class, 3)"))}
}
\concept{string functions}
