% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setProperties.R
\name{setClusters}
\alias{setClusters}
\title{Sets clustering for SoupChannel}
\usage{
setClusters(sc, clusters)
}
\arguments{
\item{sc}{A SoupChannel object.}

\item{clusters}{A named vector, where entries are the cluster IDs and names are cellIDs.  If no names are provided, the order is assumed to match the order in \code{sc$metaData}.}
}
\value{
An updated SoupChannel object with clustering information stored.
}
\description{
Adds or updates clustering information to meta-data table in SoupChannel object.
}
\examples{
sc = load10X(system.file('extdata','toyData',package='SoupX'))
mDat = read.table(system.file('extdata','toyData','metaData.tsv',package='SoupX'),sep='\t')
sc = setClusters(sc,mDat$res.1)
}
