% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_additional_sims.R
\name{rename_results_column}
\alias{rename_results_column}
\alias{rename_results_column_pattern}
\title{Rename Columns in Simulation Results and Update Attributes}
\usage{
rename_results_column(results, rename)

rename_results_column_pattern(results, pattern, replacement)
}
\arguments{
\item{results}{\code{SimDesign} object}

\item{rename}{named vector of new names}

\item{pattern}{regexp pattern as understood by \code{stringr::str_replace_all}}

\item{replacement}{replacement as understood by \code{stringr::str_replace_all}}
}
\value{
\code{SimDesign} object with updated column names
}
\description{
Rename Columns in Simulation Results and Update Attributes
}
\section{Functions}{
\itemize{
\item \code{rename_results_column()}: Rename Columns in Simulation Results

\item \code{rename_results_column_pattern()}: Rename Columns in Simulation Results by Pattern

}}
\examples{
\donttest{
condition <- merge(
assumptions_delayed_effect(),
design_fixed_followup(),
by=NULL
) |>
  tail(4) |>
  true_summary_statistics_delayed_effect(cutoff_stats = 15)

sim_results <- runSimulation(
  design=condition,
  replications=10,
  generate=generate_delayed_effect,
  analyse=list(
    logrank  = analyse_logrank(alternative = "one.sided"),
    mwlrt = analyse_modelstly_weighted(t_star = m2d(24))
  ),
  summarise = create_summarise_function(
    logrank = summarise_test(0.025),
    mwlrt = summarise_test(0.025)
  )
)

names(sim_results)
attr(sim_results, "design_names")

sim_results <- sim_results |>
  rename_results_column(c("delay"="onset"))

names(sim_results)
attr(sim_results, "design_names")
}
\donttest{
  condition <- merge(
    assumptions_delayed_effect(),
    design_fixed_followup(),
    by=NULL
  ) |>
    tail(4) |>
    true_summary_statistics_delayed_effect(cutoff_stats = 15)

  sim_results <- runSimulation(
    design=condition,
    replications=10,
    generate=generate_delayed_effect,
    analyse=list(
      logrank  = analyse_logrank(alternative = "one.sided"),
      mwlrt = analyse_modelstly_weighted(t_star = m2d(24))
    ),
    summarise = create_summarise_function(
      logrank = summarise_test(0.025),
      mwlrt = summarise_test(0.025)
    )
  )

  names(sim_results)
  attr(sim_results, "design_names")

  sim_results <- sim_results |>
    rename_results_column_pattern(pattern = "_0.025", replacement = "")

  names(sim_results)
  attr(sim_results, "design_names")
}
}
