% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/dimensional_reduction.R
\name{RunSPCA}
\alias{RunSPCA}
\alias{RunSPCA.default}
\alias{RunSPCA.Assay}
\alias{RunSPCA.Assay5}
\alias{RunSPCA.Seurat}
\title{Run Supervised Principal Component Analysis}
\usage{
RunSPCA(object, ...)

\method{RunSPCA}{default}(
  object,
  assay = NULL,
  npcs = 50,
  reduction.key = "SPC_",
  graph = NULL,
  verbose = FALSE,
  seed.use = 42,
  ...
)

\method{RunSPCA}{Assay}(
  object,
  assay = NULL,
  features = NULL,
  npcs = 50,
  reduction.key = "SPC_",
  graph = NULL,
  verbose = TRUE,
  seed.use = 42,
  ...
)

\method{RunSPCA}{Assay5}(
  object,
  assay = NULL,
  features = NULL,
  npcs = 50,
  reduction.key = "SPC_",
  graph = NULL,
  verbose = TRUE,
  seed.use = 42,
  layer = "scale.data",
  ...
)

\method{RunSPCA}{Seurat}(
  object,
  assay = NULL,
  features = NULL,
  npcs = 50,
  reduction.name = "spca",
  reduction.key = "SPC_",
  graph = NULL,
  verbose = TRUE,
  seed.use = 42,
  ...
)
}
\arguments{
\item{object}{An object}

\item{...}{Arguments passed to other methods and IRLBA}

\item{assay}{Name of Assay SPCA is being run on}

\item{npcs}{Total Number of SPCs to compute and store (50 by default)}

\item{reduction.key}{dimensional reduction key, specifies the string before
the number for the dimension names. SPC by default}

\item{graph}{Graph used supervised by SPCA}

\item{verbose}{Print the top genes associated with high/low loadings for
the SPCs}

\item{seed.use}{Set a random seed. By default, sets the seed to 42. Setting
NULL will not set a seed.}

\item{features}{Features to compute SPCA on. If features=NULL, SPCA will be run
using the variable features for the Assay.}

\item{layer}{Layer to run SPCA on}

\item{reduction.name}{dimensional reduction name, spca by default}
}
\value{
Returns Seurat object with the SPCA calculation stored in the reductions slot
}
\description{
Run a supervised PCA (SPCA) dimensionality reduction supervised by a cell-cell kernel.
SPCA is used to capture a linear transformation which maximizes its dependency to
the given cell-cell kernel. We use SNN graph as the kernel to supervise the linear
matrix factorization.
}
\references{
Barshan E, Ghodsi A, Azimifar Z, Jahromi MZ.
Supervised principal component analysis: Visualization, classification and
regression on subspaces and submanifolds.
Pattern Recognition. 2011 Jul 1;44(7):1357-71. \url{https://www.sciencedirect.com/science/article/pii/S0031320310005819?casa_token=AZMFg5OtPnAAAAAA:_Udu7GJ7G2ed1-XSmr-3IGSISUwcHfMpNtCj-qacXH5SBC4nwzVid36GXI3r8XG8dK5WOQui};
}
\concept{dimensional_reduction}
