% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R, R/convenience.R
\name{ReadVitessce}
\alias{ReadVitessce}
\alias{LoadHuBMAPCODEX}
\title{Read Data From Vitessce}
\usage{
ReadVitessce(
  counts = NULL,
  coords = NULL,
  molecules = NULL,
  type = c("segmentations", "centroids"),
  filter = NA_character_
)

LoadHuBMAPCODEX(data.dir, fov, assay = "CODEX")
}
\arguments{
\item{counts}{Path or URL to a Vitessce-formatted JSON file with
expression data; should end in \dQuote{\code{.genes.json}} or
\dQuote{\code{.clusters.json}}; pass \code{NULL} to skip}

\item{coords}{Path or URL to a Vitessce-formatted JSON file with cell/spot
spatial coordinates; should end in \dQuote{\code{.cells.json}};
pass \code{NULL} to skip}

\item{molecules}{Path or URL to a Vitessce-formatted JSON file with molecule
spatial coordinates; should end in \dQuote{\code{.molecules.json}};
pass \code{NULL} to skip}

\item{type}{Type of cell/spot spatial coordinates to return,
choose one or more from:
\itemize{
 \item \dQuote{segmentations} cell/spot segmentations
 \item \dQuote{centroids} cell/spot centroids
}}

\item{filter}{A character to filter molecules by, pass \code{NA} to skip
molecule filtering}

\item{data.dir}{Path to a directory containing Vitessce cells
and clusters JSONs}

\item{fov}{Name to store FOV as}

\item{assay}{Name to store expression matrix as}
}
\value{
\code{ReadVitessce}: A list with some combination of the
following values:
\itemize{
 \item \dQuote{\code{counts}}: if \code{counts} is not \code{NULL}, an
  expression matrix with cells as columns and features as rows
 \item \dQuote{\code{centroids}}: if \code{coords} is not \code{NULL} and
  \code{type} is contains\dQuote{centroids}, a data frame with cell centroids
  in three columns: \dQuote{x}, \dQuote{y}, and \dQuote{cell}
 \item \dQuote{\code{segmentations}}: if \code{coords} is not \code{NULL} and
  \code{type} contains \dQuote{centroids}, a data frame with cell
  segmentations in three columns: \dQuote{x}, \dQuote{y} and \dQuote{cell}
 \item \dQuote{\code{molecules}}: if \code{molecules} is not \code{NULL}, a
  data frame with molecule spatial coordinates in three columns: \dQuote{x},
  \dQuote{y}, and \dQuote{gene}
}

\code{LoadHuBMAPCODEX}: A \code{\link[SeuratObject]{Seurat}} object
}
\description{
Read in data from Vitessce-formatted JSON files
}
\note{
This function requires the
\href{https://cran.r-project.org/package=jsonlite}{\pkg{jsonlite}} package
to be installed
}
\section{Progress Updates with \pkg{progressr}}{

This function uses
\href{https://cran.r-project.org/package=progressr}{\pkg{progressr}} to
render status updates and progress bars. To enable progress updates, wrap
the function call in \code{\link[progressr]{with_progress}} or run
\code{\link[progressr:handlers]{handlers(global = TRUE)}} before running
this function. For more details about \pkg{progressr}, please read
\href{https://progressr.futureverse.org/articles/progressr-intro.html}{\code{vignette("progressr-intro")}}
}

\examples{
\dontrun{
coords <- ReadVitessce(
  counts =
     "https://s3.amazonaws.com/vitessce-data/0.0.31/master_release/wang/wang.genes.json",
  coords =
     "https://s3.amazonaws.com/vitessce-data/0.0.31/master_release/wang/wang.cells.json",
  molecules =
     "https://s3.amazonaws.com/vitessce-data/0.0.31/master_release/wang/wang.molecules.json"
)
names(coords)
coords$counts[1:10, 1:10]
head(coords$centroids)
head(coords$segmentations)
head(coords$molecules)
}

}
\concept{preprocessing}
