% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integration.R
\name{FindIntegrationAnchors}
\alias{FindIntegrationAnchors}
\title{Find integration anchors}
\usage{
FindIntegrationAnchors(object.list = NULL, assay = NULL,
  anchor.features = 2000, scale = TRUE, l2.norm = TRUE,
  dims = 1:30, k.anchor = 5, k.filter = 200, k.score = 30,
  max.features = 200, eps = 0, verbose = TRUE)
}
\arguments{
\item{object.list}{A list of objects between which to find anchors for downstream integration.}

\item{assay}{A vector of assay names specifying which assay to use when constructing anchors. If
NULL, the current default assay for each object is used.}

\item{anchor.features}{Can be either:
\itemize{
  \item{A numeric value. This will call \code{\link{SelectIntegrationFeatures}} to select the
  provided number of features to be used in anchor finding}
  \item{A vector of features to be used as input to the anchor finding process}
}}

\item{scale}{Whether or not to scale the features provided. Only set to FALSE if you have
previously scaled the features you want to use for each object in the object.list}

\item{l2.norm}{Perform L2 normalization on the CCA cell embeddings after dimensional reduction}

\item{dims}{Which dimensions to use from the CCA to specify the neighbor search space}

\item{k.anchor}{How many neighbors (k) to use when picking anchors}

\item{k.filter}{How many neighbors (k) to use when filtering anchors}

\item{k.score}{How many neighbors (k) to use when scoring anchors}

\item{max.features}{The maximum number of features to use when specifying the neighborhood search
space in the anchor filtering}

\item{eps}{Error bound on the neighbor finding algorithm (from RANN)}

\item{verbose}{Print progress bars and output}
}
\value{
Returns an AnchorSet object
}
\description{
Finds the integration anchors
}
